package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostAliasBuilder extends HostAliasFluentImpl<HostAliasBuilder> implements VisitableBuilder<HostAlias,io.fabric8.kubernetes.api.model.HostAliasBuilder>{
  public HostAliasBuilder() {
    this(false);
  }
  public HostAliasBuilder(Boolean validationEnabled) {
    this(new HostAlias(), validationEnabled);
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent) {
    this(fluent, false);
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HostAlias(), validationEnabled);
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,io.fabric8.kubernetes.api.model.HostAlias instance) {
    this(fluent, instance, false);
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent,io.fabric8.kubernetes.api.model.HostAlias instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostnames(instance.getHostnames()); 
    fluent.withIp(instance.getIp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAlias instance) {
    this(instance,false);
  }
  public HostAliasBuilder(io.fabric8.kubernetes.api.model.HostAlias instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostnames(instance.getHostnames()); 
    this.withIp(instance.getIp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.HostAliasFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.HostAlias build() {
    HostAlias buildable = new HostAlias(fluent.getHostnames(),fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}