package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostPathVolumeSourceBuilder extends HostPathVolumeSourceFluentImpl<HostPathVolumeSourceBuilder> implements VisitableBuilder<HostPathVolumeSource,io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder>{
  public HostPathVolumeSourceBuilder() {
    this(false);
  }
  public HostPathVolumeSourceBuilder(Boolean validationEnabled) {
    this(new HostPathVolumeSource(), validationEnabled);
  }
  public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HostPathVolumeSource(), validationEnabled);
  }
  public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.HostPathVolumeSource instance) {
    this(fluent, instance, false);
  }
  public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.HostPathVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSource instance) {
    this(instance,false);
  }
  public HostPathVolumeSourceBuilder(io.fabric8.kubernetes.api.model.HostPathVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.HostPathVolumeSource build() {
    HostPathVolumeSource buildable = new HostPathVolumeSource(fluent.getPath(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}