package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ISCSIPersistentVolumeSourceBuilder extends ISCSIPersistentVolumeSourceFluentImpl<ISCSIPersistentVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource,io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceBuilder>{
  public ISCSIPersistentVolumeSourceBuilder() {
    this(false);
  }
  public ISCSIPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ISCSIPersistentVolumeSource(), validationEnabled);
  }
  public ISCSIPersistentVolumeSourceBuilder(ISCSIPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ISCSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ISCSIPersistentVolumeSource(), validationEnabled);
  }
  public ISCSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ISCSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
    fluent.withChapAuthSession(instance.getChapAuthSession()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withInitiatorName(instance.getInitiatorName()); 
    fluent.withIqn(instance.getIqn()); 
    fluent.withIscsiInterface(instance.getIscsiInterface()); 
    fluent.withLun(instance.getLun()); 
    fluent.withPortals(instance.getPortals()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withTargetPortal(instance.getTargetPortal()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ISCSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource instance) {
    this(instance,false);
  }
  public ISCSIPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
    this.withChapAuthSession(instance.getChapAuthSession()); 
    this.withFsType(instance.getFsType()); 
    this.withInitiatorName(instance.getInitiatorName()); 
    this.withIqn(instance.getIqn()); 
    this.withIscsiInterface(instance.getIscsiInterface()); 
    this.withLun(instance.getLun()); 
    this.withPortals(instance.getPortals()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withTargetPortal(instance.getTargetPortal()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource build() {
    ISCSIPersistentVolumeSource buildable = new ISCSIPersistentVolumeSource(fluent.getChapAuthDiscovery(),fluent.getChapAuthSession(),fluent.getFsType(),fluent.getInitiatorName(),fluent.getIqn(),fluent.getIscsiInterface(),fluent.getLun(),fluent.getPortals(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getTargetPortal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}