package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ISCSIVolumeSourceBuilder extends ISCSIVolumeSourceFluentImpl<ISCSIVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ISCSIVolumeSource,ISCSIVolumeSourceBuilder>{
  public ISCSIVolumeSourceBuilder() {
    this(false);
  }
  public ISCSIVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ISCSIVolumeSource(), validationEnabled);
  }
  public ISCSIVolumeSourceBuilder(ISCSIVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ISCSIVolumeSource(), validationEnabled);
  }
  public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
    fluent.withChapAuthSession(instance.getChapAuthSession()); 
    fluent.withFsType(instance.getFsType()); 
    fluent.withInitiatorName(instance.getInitiatorName()); 
    fluent.withIqn(instance.getIqn()); 
    fluent.withIscsiInterface(instance.getIscsiInterface()); 
    fluent.withLun(instance.getLun()); 
    fluent.withPortals(instance.getPortals()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withTargetPortal(instance.getTargetPortal()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance) {
    this(instance,false);
  }
  public ISCSIVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
    this.withChapAuthSession(instance.getChapAuthSession()); 
    this.withFsType(instance.getFsType()); 
    this.withInitiatorName(instance.getInitiatorName()); 
    this.withIqn(instance.getIqn()); 
    this.withIscsiInterface(instance.getIscsiInterface()); 
    this.withLun(instance.getLun()); 
    this.withPortals(instance.getPortals()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withTargetPortal(instance.getTargetPortal()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSource build() {
    ISCSIVolumeSource buildable = new ISCSIVolumeSource(fluent.getChapAuthDiscovery(),fluent.getChapAuthSession(),fluent.getFsType(),fluent.getInitiatorName(),fluent.getIqn(),fluent.getIscsiInterface(),fluent.getLun(),fluent.getPortals(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getTargetPortal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}