package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ISCSIVolumeSourceFluentImpl<A extends ISCSIVolumeSourceFluent<A>> extends BaseFluent<A> implements ISCSIVolumeSourceFluent<A>{
  public ISCSIVolumeSourceFluentImpl() {
  }
  public ISCSIVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.ISCSIVolumeSource instance) {
    this.withChapAuthDiscovery(instance.getChapAuthDiscovery()); 
    this.withChapAuthSession(instance.getChapAuthSession()); 
    this.withFsType(instance.getFsType()); 
    this.withInitiatorName(instance.getInitiatorName()); 
    this.withIqn(instance.getIqn()); 
    this.withIscsiInterface(instance.getIscsiInterface()); 
    this.withLun(instance.getLun()); 
    this.withPortals(instance.getPortals()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withTargetPortal(instance.getTargetPortal()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean chapAuthDiscovery;
  private java.lang.Boolean chapAuthSession;
  private String fsType;
  private java.lang.String initiatorName;
  private java.lang.String iqn;
  private java.lang.String iscsiInterface;
  private Integer lun;
  private List<java.lang.String> portals = new ArrayList<java.lang.String>();
  private java.lang.Boolean readOnly;
  private LocalObjectReferenceBuilder secretRef;
  private java.lang.String targetPortal;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.Boolean getChapAuthDiscovery() {
    return this.chapAuthDiscovery;
  }
  public A withChapAuthDiscovery(java.lang.Boolean chapAuthDiscovery) {
    this.chapAuthDiscovery=chapAuthDiscovery; return (A) this;
  }
  public java.lang.Boolean hasChapAuthDiscovery() {
    return this.chapAuthDiscovery != null;
  }
  public java.lang.Boolean getChapAuthSession() {
    return this.chapAuthSession;
  }
  public A withChapAuthSession(java.lang.Boolean chapAuthSession) {
    this.chapAuthSession=chapAuthSession; return (A) this;
  }
  public java.lang.Boolean hasChapAuthSession() {
    return this.chapAuthSession != null;
  }
  public java.lang.String getFsType() {
    return this.fsType;
  }
  public A withFsType(java.lang.String fsType) {
    this.fsType=fsType; return (A) this;
  }
  public java.lang.Boolean hasFsType() {
    return this.fsType != null;
  }
  public java.lang.String getInitiatorName() {
    return this.initiatorName;
  }
  public A withInitiatorName(java.lang.String initiatorName) {
    this.initiatorName=initiatorName; return (A) this;
  }
  public java.lang.Boolean hasInitiatorName() {
    return this.initiatorName != null;
  }
  public java.lang.String getIqn() {
    return this.iqn;
  }
  public A withIqn(java.lang.String iqn) {
    this.iqn=iqn; return (A) this;
  }
  public java.lang.Boolean hasIqn() {
    return this.iqn != null;
  }
  public java.lang.String getIscsiInterface() {
    return this.iscsiInterface;
  }
  public A withIscsiInterface(java.lang.String iscsiInterface) {
    this.iscsiInterface=iscsiInterface; return (A) this;
  }
  public java.lang.Boolean hasIscsiInterface() {
    return this.iscsiInterface != null;
  }
  public java.lang.Integer getLun() {
    return this.lun;
  }
  public A withLun(java.lang.Integer lun) {
    this.lun=lun; return (A) this;
  }
  public java.lang.Boolean hasLun() {
    return this.lun != null;
  }
  public A addToPortals(java.lang.Integer index,java.lang.String item) {
    if (this.portals == null) {this.portals = new java.util.ArrayList<java.lang.String>();}
    this.portals.add(index, item);
    return (A)this;
  }
  public A setToPortals(java.lang.Integer index,java.lang.String item) {
    if (this.portals == null) {this.portals = new java.util.ArrayList<java.lang.String>();}
    this.portals.set(index, item); return (A)this;
  }
  public A addToPortals(java.lang.String... items) {
    if (this.portals == null) {this.portals = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.portals.add(item);} return (A)this;
  }
  public A addAllToPortals(Collection<java.lang.String> items) {
    if (this.portals == null) {this.portals = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.portals.add(item);} return (A)this;
  }
  public A removeFromPortals(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.portals!= null){ this.portals.remove(item);}} return (A)this;
  }
  public A removeAllFromPortals(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.portals!= null){ this.portals.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getPortals() {
    return this.portals;
  }
  public java.lang.String getPortal(java.lang.Integer index) {
    return this.portals.get(index);
  }
  public java.lang.String getFirstPortal() {
    return this.portals.get(0);
  }
  public java.lang.String getLastPortal() {
    return this.portals.get(portals.size() - 1);
  }
  public java.lang.String getMatchingPortal(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: portals) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingPortal(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: portals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPortals(java.util.List<java.lang.String> portals) {
    if (portals != null) {this.portals = new java.util.ArrayList(); for (java.lang.String item : portals){this.addToPortals(item);}} else { this.portals = null;} return (A) this;
  }
  public A withPortals(java.lang.String... portals) {
    if (this.portals != null) {this.portals.clear();}
    if (portals != null) {for (java.lang.String item :portals){ this.addToPortals(item);}} return (A) this;
  }
  public java.lang.Boolean hasPortals() {
    return portals != null && !portals.isEmpty();
  }
  public java.lang.Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(java.lang.Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public java.lang.Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(io.fabric8.kubernetes.api.model.LocalObjectReference secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
  }
  public java.lang.Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(java.lang.String name) {
    return (A)withSecretRef(new LocalObjectReference(name));
  }
  public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
    return new ISCSIVolumeSourceFluentImpl.SecretRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new ISCSIVolumeSourceFluentImpl.SecretRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public java.lang.String getTargetPortal() {
    return this.targetPortal;
  }
  public A withTargetPortal(java.lang.String targetPortal) {
    this.targetPortal=targetPortal; return (A) this;
  }
  public java.lang.Boolean hasTargetPortal() {
    return this.targetPortal != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl) o;
    if (chapAuthDiscovery != null ? !chapAuthDiscovery.equals(that.chapAuthDiscovery) :that.chapAuthDiscovery != null) return false;
    if (chapAuthSession != null ? !chapAuthSession.equals(that.chapAuthSession) :that.chapAuthSession != null) return false;
    if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
    if (initiatorName != null ? !initiatorName.equals(that.initiatorName) :that.initiatorName != null) return false;
    if (iqn != null ? !iqn.equals(that.iqn) :that.iqn != null) return false;
    if (iscsiInterface != null ? !iscsiInterface.equals(that.iscsiInterface) :that.iscsiInterface != null) return false;
    if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
    if (portals != null ? !portals.equals(that.portals) :that.portals != null) return false;
    if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    if (targetPortal != null ? !targetPortal.equals(that.targetPortal) :that.targetPortal != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(chapAuthDiscovery,  chapAuthSession,  fsType,  initiatorName,  iqn,  iscsiInterface,  lun,  portals,  readOnly,  secretRef,  targetPortal,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (chapAuthDiscovery != null) { sb.append("chapAuthDiscovery:"); sb.append(chapAuthDiscovery + ","); }
    if (chapAuthSession != null) { sb.append("chapAuthSession:"); sb.append(chapAuthSession + ","); }
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (initiatorName != null) { sb.append("initiatorName:"); sb.append(initiatorName + ","); }
    if (iqn != null) { sb.append("iqn:"); sb.append(iqn + ","); }
    if (iscsiInterface != null) { sb.append("iscsiInterface:"); sb.append(iscsiInterface + ","); }
    if (lun != null) { sb.append("lun:"); sb.append(lun + ","); }
    if (portals != null && !portals.isEmpty()) { sb.append("portals:"); sb.append(portals + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (targetPortal != null) { sb.append("targetPortal:"); sb.append(targetPortal + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withChapAuthDiscovery() {
    return withChapAuthDiscovery(true);
  }
  public A withChapAuthSession() {
    return withChapAuthSession(true);
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ISCSIVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ISCSIVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}