package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KeyToPathBuilder extends KeyToPathFluentImpl<KeyToPathBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.KeyToPath,KeyToPathBuilder>{
  public KeyToPathBuilder() {
    this(false);
  }
  public KeyToPathBuilder(Boolean validationEnabled) {
    this(new KeyToPath(), validationEnabled);
  }
  public KeyToPathBuilder(KeyToPathFluent<?> fluent) {
    this(fluent, false);
  }
  public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KeyToPath(), validationEnabled);
  }
  public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,io.fabric8.kubernetes.api.model.KeyToPath instance) {
    this(fluent, instance, false);
  }
  public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent,io.fabric8.kubernetes.api.model.KeyToPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPath(instance.getPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPath instance) {
    this(instance,false);
  }
  public KeyToPathBuilder(io.fabric8.kubernetes.api.model.KeyToPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withMode(instance.getMode()); 
    this.withPath(instance.getPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.KeyToPathFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.KeyToPath build() {
    KeyToPath buildable = new KeyToPath(fluent.getKey(),fluent.getMode(),fluent.getPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}