package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubernetesListBuilder extends KubernetesListFluentImpl<KubernetesListBuilder> implements VisitableBuilder<KubernetesList,io.fabric8.kubernetes.api.model.KubernetesListBuilder>{
  public KubernetesListBuilder() {
    this(false);
  }
  public KubernetesListBuilder(Boolean validationEnabled) {
    this(new KubernetesList(), validationEnabled);
  }
  public KubernetesListBuilder(KubernetesListFluent<?> fluent) {
    this(fluent, false);
  }
  public KubernetesListBuilder(io.fabric8.kubernetes.api.model.KubernetesListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KubernetesList(), validationEnabled);
  }
  public KubernetesListBuilder(io.fabric8.kubernetes.api.model.KubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.KubernetesList instance) {
    this(fluent, instance, false);
  }
  public KubernetesListBuilder(io.fabric8.kubernetes.api.model.KubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.KubernetesList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubernetesListBuilder(io.fabric8.kubernetes.api.model.KubernetesList instance) {
    this(instance,false);
  }
  public KubernetesListBuilder(io.fabric8.kubernetes.api.model.KubernetesList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.KubernetesListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.KubernetesList build() {
    KubernetesList buildable = new KubernetesList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}