package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LabelSelectorBuilder extends LabelSelectorFluentImpl<LabelSelectorBuilder> implements VisitableBuilder<LabelSelector,io.fabric8.kubernetes.api.model.LabelSelectorBuilder>{
  public LabelSelectorBuilder() {
    this(false);
  }
  public LabelSelectorBuilder(Boolean validationEnabled) {
    this(new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.LabelSelector instance) {
    this(fluent, instance, false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.LabelSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchExpressions(instance.getMatchExpressions()); 
    fluent.withMatchLabels(instance.getMatchLabels()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelector instance) {
    this(instance,false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withMatchLabels(instance.getMatchLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LabelSelector build() {
    LabelSelector buildable = new LabelSelector(fluent.getMatchExpressions(),fluent.getMatchLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}