package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LabelSelectorFluentImpl<A extends LabelSelectorFluent<A>> extends BaseFluent<A> implements LabelSelectorFluent<A>{
  public LabelSelectorFluentImpl() {
  }
  public LabelSelectorFluentImpl(io.fabric8.kubernetes.api.model.LabelSelector instance) {
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withMatchLabels(instance.getMatchLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<LabelSelectorRequirementBuilder> matchExpressions = new java.util.ArrayList<LabelSelectorRequirementBuilder>();
  private Map<String,java.lang.String> matchLabels;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public A addToMatchExpressions(Integer index,io.fabric8.kubernetes.api.model.LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder>();}
    io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
  }
  public A setToMatchExpressions(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder>();}
    io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);
    if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
    if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
     return (A)this;
  }
  public A addToMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    if (this.matchExpressions == null) {this.matchExpressions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder>();}
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A addAllToMatchExpressions(Collection<io.fabric8.kubernetes.api.model.LabelSelectorRequirement> items) {
    if (this.matchExpressions == null) {this.matchExpressions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder>();}
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
  }
  public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchExpressions(java.util.Collection<io.fabric8.kubernetes.api.model.LabelSelectorRequirement> items) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item : items) {io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchExpressions(Predicate<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder> predicate) {
    if (matchExpressions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder> each = matchExpressions.iterator();
    final List visitables = _visitables.get("matchExpressions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchExpressions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.LabelSelectorRequirement> getMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.LabelSelectorRequirement> buildMatchExpressions() {
    return matchExpressions != null ? build(matchExpressions) : null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorRequirement buildMatchExpression(java.lang.Integer index) {
    return this.matchExpressions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorRequirement buildFirstMatchExpression() {
    return this.matchExpressions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorRequirement buildLastMatchExpression() {
    return this.matchExpressions.get(matchExpressions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorRequirement buildMatchingMatchExpression(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatchExpression(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder item: matchExpressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchExpressions(java.util.List<io.fabric8.kubernetes.api.model.LabelSelectorRequirement> matchExpressions) {
    if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
    if (matchExpressions != null) {this.matchExpressions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
  }
  public A withMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... matchExpressions) {
    if (this.matchExpressions != null) {this.matchExpressions.clear();}
    if (matchExpressions != null) {for (io.fabric8.kubernetes.api.model.LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
  }
  public java.lang.Boolean hasMatchExpressions() {
    return matchExpressions != null && !matchExpressions.isEmpty();
  }
  public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression() {
    return new LabelSelectorFluentImpl.MatchExpressionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(io.fabric8.kubernetes.api.model.LabelSelectorRequirement item) {
    return new LabelSelectorFluentImpl.MatchExpressionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LabelSelectorRequirement item) {
    return new io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl.MatchExpressionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editMatchExpression(java.lang.Integer index) {
    if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
    if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(0, buildMatchExpression(0));
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression() {
    int index = matchExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchExpressions.size();i++) { 
    if (predicate.test(matchExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
    return setNewMatchExpressionLike(index, buildMatchExpression(index));
  }
  public A addToMatchLabels(java.lang.String key,java.lang.String value) {
    if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
  }
  public A addToMatchLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.matchLabels == null && map != null) { this.matchLabels = new java.util.LinkedHashMap(); }
    if(map != null) { this.matchLabels.putAll(map);} return (A)this;
  }
  public A removeFromMatchLabels(java.lang.String key) {
    if(this.matchLabels == null) { return (A) this; }
    if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
  }
  public A removeFromMatchLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.matchLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getMatchLabels() {
    return this.matchLabels;
  }
  public <K,V>A withMatchLabels(java.util.Map<java.lang.String,java.lang.String> matchLabels) {
    if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new java.util.LinkedHashMap(matchLabels);} return (A) this;
  }
  public java.lang.Boolean hasMatchLabels() {
    return this.matchLabels != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LabelSelectorFluentImpl that = (LabelSelectorFluentImpl) o;
    if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
    if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchExpressions,  matchLabels,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchExpressions != null && !matchExpressions.isEmpty()) { sb.append("matchExpressions:"); sb.append(matchExpressions + ","); }
    if (matchLabels != null && !matchLabels.isEmpty()) { sb.append("matchLabels:"); sb.append(matchLabels + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchExpressionsNestedImpl<N> extends LabelSelectorRequirementFluentImpl<LabelSelectorFluent.MatchExpressionsNested<N>> implements io.fabric8.kubernetes.api.model.LabelSelectorFluent.MatchExpressionsNested<N>,Nested<N>{
    MatchExpressionsNestedImpl(java.lang.Integer index,LabelSelectorRequirement item) {
      this.index = index;
      this.builder = new LabelSelectorRequirementBuilder(this, item);
    }
    MatchExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) LabelSelectorFluentImpl.this.setToMatchExpressions(index,builder.build());
    }
    public N endMatchExpression() {
      return and();
    }
    
  }
  
}