package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleBuilder extends LifecycleFluentImpl<LifecycleBuilder> implements VisitableBuilder<Lifecycle,io.fabric8.kubernetes.api.model.LifecycleBuilder>{
  public LifecycleBuilder() {
    this(false);
  }
  public LifecycleBuilder(Boolean validationEnabled) {
    this(new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.LifecycleFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.LifecycleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.LifecycleFluent<?> fluent,io.fabric8.kubernetes.api.model.Lifecycle instance) {
    this(fluent, instance, false);
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.LifecycleFluent<?> fluent,io.fabric8.kubernetes.api.model.Lifecycle instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPostStart(instance.getPostStart()); 
    fluent.withPreStop(instance.getPreStop()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.Lifecycle instance) {
    this(instance,false);
  }
  public LifecycleBuilder(io.fabric8.kubernetes.api.model.Lifecycle instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPostStart(instance.getPostStart()); 
    this.withPreStop(instance.getPreStop()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LifecycleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Lifecycle build() {
    Lifecycle buildable = new Lifecycle(fluent.getPostStart(),fluent.getPreStop());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}