package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitRangeBuilder extends LimitRangeFluentImpl<LimitRangeBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.LimitRange,LimitRangeBuilder>{
  public LimitRangeBuilder() {
    this(false);
  }
  public LimitRangeBuilder(Boolean validationEnabled) {
    this(new LimitRange(), validationEnabled);
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRangeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LimitRange(), validationEnabled);
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRangeFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRange instance) {
    this(fluent, instance, false);
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRangeFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRange instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRange instance) {
    this(instance,false);
  }
  public LimitRangeBuilder(io.fabric8.kubernetes.api.model.LimitRange instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LimitRangeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LimitRange build() {
    LimitRange buildable = new LimitRange(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}