package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitRangeListBuilder extends LimitRangeListFluentImpl<LimitRangeListBuilder> implements VisitableBuilder<LimitRangeList,io.fabric8.kubernetes.api.model.LimitRangeListBuilder>{
  public LimitRangeListBuilder() {
    this(false);
  }
  public LimitRangeListBuilder(Boolean validationEnabled) {
    this(new LimitRangeList(), validationEnabled);
  }
  public LimitRangeListBuilder(LimitRangeListFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LimitRangeList(), validationEnabled);
  }
  public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeList instance) {
    this(fluent, instance, false);
  }
  public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeList instance) {
    this(instance,false);
  }
  public LimitRangeListBuilder(io.fabric8.kubernetes.api.model.LimitRangeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LimitRangeListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LimitRangeList build() {
    LimitRangeList buildable = new LimitRangeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}