package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitRangeSpecBuilder extends LimitRangeSpecFluentImpl<LimitRangeSpecBuilder> implements VisitableBuilder<LimitRangeSpec,io.fabric8.kubernetes.api.model.LimitRangeSpecBuilder>{
  public LimitRangeSpecBuilder() {
    this(false);
  }
  public LimitRangeSpecBuilder(Boolean validationEnabled) {
    this(new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LimitRangeSpec(), validationEnabled);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeSpec instance) {
    this(fluent, instance, false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.LimitRangeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLimits(instance.getLimits()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpec instance) {
    this(instance,false);
  }
  public LimitRangeSpecBuilder(io.fabric8.kubernetes.api.model.LimitRangeSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLimits(instance.getLimits()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LimitRangeSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LimitRangeSpec build() {
    LimitRangeSpec buildable = new LimitRangeSpec(fluent.getLimits());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}