package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListMetaBuilder extends ListMetaFluentImpl<ListMetaBuilder> implements VisitableBuilder<ListMeta,io.fabric8.kubernetes.api.model.ListMetaBuilder>{
  public ListMetaBuilder() {
    this(false);
  }
  public ListMetaBuilder(Boolean validationEnabled) {
    this(new ListMeta(), validationEnabled);
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMetaFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ListMeta(), validationEnabled);
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMetaFluent<?> fluent,io.fabric8.kubernetes.api.model.ListMeta instance) {
    this(fluent, instance, false);
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMetaFluent<?> fluent,io.fabric8.kubernetes.api.model.ListMeta instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContinue(instance.getContinue()); 
    fluent.withRemainingItemCount(instance.getRemainingItemCount()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withSelfLink(instance.getSelfLink()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMeta instance) {
    this(instance,false);
  }
  public ListMetaBuilder(io.fabric8.kubernetes.api.model.ListMeta instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContinue(instance.getContinue()); 
    this.withRemainingItemCount(instance.getRemainingItemCount()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withSelfLink(instance.getSelfLink()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ListMetaFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ListMeta build() {
    ListMeta buildable = new ListMeta(fluent.getContinue(),fluent.getRemainingItemCount(),fluent.getResourceVersion(),fluent.getSelfLink());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}