package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerIngressBuilder extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.LoadBalancerIngress,io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder>{
  public LoadBalancerIngressBuilder() {
    this(false);
  }
  public LoadBalancerIngressBuilder(Boolean validationEnabled) {
    this(new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerIngress(), validationEnabled);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerIngress instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostname(instance.getHostname()); 
    fluent.withIp(instance.getIp()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngress instance) {
    this(instance,false);
  }
  public LoadBalancerIngressBuilder(io.fabric8.kubernetes.api.model.LoadBalancerIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostname(instance.getHostname()); 
    this.withIp(instance.getIp()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LoadBalancerIngress build() {
    LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp(),fluent.getPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}