package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerStatusBuilder extends LoadBalancerStatusFluentImpl<LoadBalancerStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.LoadBalancerStatus,LoadBalancerStatusBuilder>{
  public LoadBalancerStatusBuilder() {
    this(false);
  }
  public LoadBalancerStatusBuilder(Boolean validationEnabled) {
    this(new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerStatus instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIngress(instance.getIngress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatus instance) {
    this(instance,false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LoadBalancerStatus build() {
    LoadBalancerStatus buildable = new LoadBalancerStatus(fluent.getIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}