package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalObjectReferenceBuilder extends LocalObjectReferenceFluentImpl<LocalObjectReferenceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.LocalObjectReference,io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder>{
  public LocalObjectReferenceBuilder() {
    this(false);
  }
  public LocalObjectReferenceBuilder(Boolean validationEnabled) {
    this(new LocalObjectReference(), validationEnabled);
  }
  public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LocalObjectReference(), validationEnabled);
  }
  public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalObjectReference instance) {
    this(fluent, instance, false);
  }
  public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReference instance) {
    this(instance,false);
  }
  public LocalObjectReferenceBuilder(io.fabric8.kubernetes.api.model.LocalObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LocalObjectReference build() {
    LocalObjectReference buildable = new LocalObjectReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}