package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalVolumeSourceBuilder extends LocalVolumeSourceFluentImpl<LocalVolumeSourceBuilder> implements VisitableBuilder<LocalVolumeSource,io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder>{
  public LocalVolumeSourceBuilder() {
    this(false);
  }
  public LocalVolumeSourceBuilder(Boolean validationEnabled) {
    this(new LocalVolumeSource(), validationEnabled);
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LocalVolumeSource(), validationEnabled);
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalVolumeSource instance) {
    this(fluent, instance, false);
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withPath(instance.getPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSource instance) {
    this(instance,false);
  }
  public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withPath(instance.getPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LocalVolumeSource build() {
    LocalVolumeSource buildable = new LocalVolumeSource(fluent.getFsType(),fluent.getPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}