package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedFieldsEntryBuilder extends ManagedFieldsEntryFluentImpl<ManagedFieldsEntryBuilder> implements VisitableBuilder<ManagedFieldsEntry,io.fabric8.kubernetes.api.model.ManagedFieldsEntryBuilder>{
  public ManagedFieldsEntryBuilder() {
    this(false);
  }
  public ManagedFieldsEntryBuilder(Boolean validationEnabled) {
    this(new ManagedFieldsEntry(), validationEnabled);
  }
  public ManagedFieldsEntryBuilder(ManagedFieldsEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedFieldsEntryBuilder(io.fabric8.kubernetes.api.model.ManagedFieldsEntryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ManagedFieldsEntry(), validationEnabled);
  }
  public ManagedFieldsEntryBuilder(io.fabric8.kubernetes.api.model.ManagedFieldsEntryFluent<?> fluent,io.fabric8.kubernetes.api.model.ManagedFieldsEntry instance) {
    this(fluent, instance, false);
  }
  public ManagedFieldsEntryBuilder(io.fabric8.kubernetes.api.model.ManagedFieldsEntryFluent<?> fluent,io.fabric8.kubernetes.api.model.ManagedFieldsEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withFieldsType(instance.getFieldsType()); 
    fluent.withFieldsV1(instance.getFieldsV1()); 
    fluent.withManager(instance.getManager()); 
    fluent.withOperation(instance.getOperation()); 
    fluent.withSubresource(instance.getSubresource()); 
    fluent.withTime(instance.getTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ManagedFieldsEntryBuilder(io.fabric8.kubernetes.api.model.ManagedFieldsEntry instance) {
    this(instance,false);
  }
  public ManagedFieldsEntryBuilder(io.fabric8.kubernetes.api.model.ManagedFieldsEntry instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withFieldsType(instance.getFieldsType()); 
    this.withFieldsV1(instance.getFieldsV1()); 
    this.withManager(instance.getManager()); 
    this.withOperation(instance.getOperation()); 
    this.withSubresource(instance.getSubresource()); 
    this.withTime(instance.getTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ManagedFieldsEntryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ManagedFieldsEntry build() {
    ManagedFieldsEntry buildable = new ManagedFieldsEntry(fluent.getApiVersion(),fluent.getFieldsType(),fluent.getFieldsV1(),fluent.getManager(),fluent.getOperation(),fluent.getSubresource(),fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}