package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MicroTimeBuilder extends MicroTimeFluentImpl<MicroTimeBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.MicroTime,MicroTimeBuilder>{
  public MicroTimeBuilder() {
    this(false);
  }
  public MicroTimeBuilder(Boolean validationEnabled) {
    this(new MicroTime(), validationEnabled);
  }
  public MicroTimeBuilder(MicroTimeFluent<?> fluent) {
    this(fluent, false);
  }
  public MicroTimeBuilder(io.fabric8.kubernetes.api.model.MicroTimeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MicroTime(), validationEnabled);
  }
  public MicroTimeBuilder(io.fabric8.kubernetes.api.model.MicroTimeFluent<?> fluent,io.fabric8.kubernetes.api.model.MicroTime instance) {
    this(fluent, instance, false);
  }
  public MicroTimeBuilder(io.fabric8.kubernetes.api.model.MicroTimeFluent<?> fluent,io.fabric8.kubernetes.api.model.MicroTime instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTime(instance.getTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MicroTimeBuilder(io.fabric8.kubernetes.api.model.MicroTime instance) {
    this(instance,false);
  }
  public MicroTimeBuilder(io.fabric8.kubernetes.api.model.MicroTime instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withTime(instance.getTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.MicroTimeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.MicroTime build() {
    MicroTime buildable = new MicroTime(fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}