package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedAuthInfoBuilder extends NamedAuthInfoFluentImpl<NamedAuthInfoBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamedAuthInfo,NamedAuthInfoBuilder>{
  public NamedAuthInfoBuilder() {
    this(false);
  }
  public NamedAuthInfoBuilder(Boolean validationEnabled) {
    this(new NamedAuthInfo(), validationEnabled);
  }
  public NamedAuthInfoBuilder(NamedAuthInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedAuthInfoBuilder(io.fabric8.kubernetes.api.model.NamedAuthInfoFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedAuthInfo(), validationEnabled);
  }
  public NamedAuthInfoBuilder(io.fabric8.kubernetes.api.model.NamedAuthInfoFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedAuthInfo instance) {
    this(fluent, instance, false);
  }
  public NamedAuthInfoBuilder(io.fabric8.kubernetes.api.model.NamedAuthInfoFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedAuthInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamedAuthInfoBuilder(io.fabric8.kubernetes.api.model.NamedAuthInfo instance) {
    this(instance,false);
  }
  public NamedAuthInfoBuilder(io.fabric8.kubernetes.api.model.NamedAuthInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedAuthInfoFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedAuthInfo build() {
    NamedAuthInfo buildable = new NamedAuthInfo(fluent.getName(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}