package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedClusterBuilder extends NamedClusterFluentImpl<NamedClusterBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamedCluster,io.fabric8.kubernetes.api.model.NamedClusterBuilder>{
  public NamedClusterBuilder() {
    this(false);
  }
  public NamedClusterBuilder(Boolean validationEnabled) {
    this(new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedCluster(), validationEnabled);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedCluster instance) {
    this(fluent, instance, false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCluster(instance.getCluster()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedCluster instance) {
    this(instance,false);
  }
  public NamedClusterBuilder(io.fabric8.kubernetes.api.model.NamedCluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCluster(instance.getCluster()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedClusterFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedCluster build() {
    NamedCluster buildable = new NamedCluster(fluent.getCluster(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}