package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedContextBuilder extends NamedContextFluentImpl<NamedContextBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamedContext,NamedContextBuilder>{
  public NamedContextBuilder() {
    this(false);
  }
  public NamedContextBuilder(Boolean validationEnabled) {
    this(new NamedContext(), validationEnabled);
  }
  public NamedContextBuilder(NamedContextFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedContext(), validationEnabled);
  }
  public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedContext instance) {
    this(fluent, instance, false);
  }
  public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContext(instance.getContext()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContext instance) {
    this(instance,false);
  }
  public NamedContextBuilder(io.fabric8.kubernetes.api.model.NamedContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContext(instance.getContext()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedContextFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedContext build() {
    NamedContext buildable = new NamedContext(fluent.getContext(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}