package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedExtensionBuilder extends NamedExtensionFluentImpl<NamedExtensionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamedExtension,io.fabric8.kubernetes.api.model.NamedExtensionBuilder>{
  public NamedExtensionBuilder() {
    this(false);
  }
  public NamedExtensionBuilder(Boolean validationEnabled) {
    this(new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(NamedExtensionFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedExtension instance) {
    this(fluent, instance, false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamedExtension instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExtension(instance.getExtension()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtension instance) {
    this(instance,false);
  }
  public NamedExtensionBuilder(io.fabric8.kubernetes.api.model.NamedExtension instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExtension(instance.getExtension()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamedExtensionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamedExtension build() {
    NamedExtension buildable = new NamedExtension(fluent.getExtension(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}