package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceBuilder extends NamespaceFluentImpl<NamespaceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Namespace,NamespaceBuilder>{
  public NamespaceBuilder() {
    this(false);
  }
  public NamespaceBuilder(Boolean validationEnabled) {
    this(new Namespace(), validationEnabled);
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.NamespaceFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.NamespaceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Namespace(), validationEnabled);
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.NamespaceFluent<?> fluent,io.fabric8.kubernetes.api.model.Namespace instance) {
    this(fluent, instance, false);
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.NamespaceFluent<?> fluent,io.fabric8.kubernetes.api.model.Namespace instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.Namespace instance) {
    this(instance,false);
  }
  public NamespaceBuilder(io.fabric8.kubernetes.api.model.Namespace instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamespaceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Namespace build() {
    Namespace buildable = new Namespace(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}