package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceConditionBuilder extends NamespaceConditionFluentImpl<NamespaceConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamespaceCondition,io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>{
  public NamespaceConditionBuilder() {
    this(false);
  }
  public NamespaceConditionBuilder(Boolean validationEnabled) {
    this(new NamespaceCondition(), validationEnabled);
  }
  public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceConditionBuilder(io.fabric8.kubernetes.api.model.NamespaceConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamespaceCondition(), validationEnabled);
  }
  public NamespaceConditionBuilder(io.fabric8.kubernetes.api.model.NamespaceConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceCondition instance) {
    this(fluent, instance, false);
  }
  public NamespaceConditionBuilder(io.fabric8.kubernetes.api.model.NamespaceConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamespaceConditionBuilder(io.fabric8.kubernetes.api.model.NamespaceCondition instance) {
    this(instance,false);
  }
  public NamespaceConditionBuilder(io.fabric8.kubernetes.api.model.NamespaceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamespaceConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamespaceCondition build() {
    NamespaceCondition buildable = new NamespaceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}