package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceStatusBuilder extends NamespaceStatusFluentImpl<NamespaceStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NamespaceStatus,io.fabric8.kubernetes.api.model.NamespaceStatusBuilder>{
  public NamespaceStatusBuilder() {
    this(false);
  }
  public NamespaceStatusBuilder(Boolean validationEnabled) {
    this(new NamespaceStatus(), validationEnabled);
  }
  public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceStatusBuilder(io.fabric8.kubernetes.api.model.NamespaceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NamespaceStatus(), validationEnabled);
  }
  public NamespaceStatusBuilder(io.fabric8.kubernetes.api.model.NamespaceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceStatus instance) {
    this(fluent, instance, false);
  }
  public NamespaceStatusBuilder(io.fabric8.kubernetes.api.model.NamespaceStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NamespaceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamespaceStatusBuilder(io.fabric8.kubernetes.api.model.NamespaceStatus instance) {
    this(instance,false);
  }
  public NamespaceStatusBuilder(io.fabric8.kubernetes.api.model.NamespaceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NamespaceStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NamespaceStatus build() {
    NamespaceStatus buildable = new NamespaceStatus(fluent.getConditions(),fluent.getPhase());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}