package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NamespaceStatusFluentImpl<A extends NamespaceStatusFluent<A>> extends BaseFluent<A> implements NamespaceStatusFluent<A>{
  public NamespaceStatusFluentImpl() {
  }
  public NamespaceStatusFluentImpl(io.fabric8.kubernetes.api.model.NamespaceStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<NamespaceConditionBuilder> conditions = new java.util.ArrayList<NamespaceConditionBuilder>();
  private String phase;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToConditions(Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
    io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
    io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.NamespaceCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.NamespaceConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public NamespaceStatusFluent.ConditionsNested<A> addNewCondition() {
    return new NamespaceStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    return new NamespaceStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NamespaceStatusFluentImpl that = (NamespaceStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  phase,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends NamespaceConditionFluentImpl<NamespaceStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.NamespaceStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
      this.index = index;
      this.builder = new NamespaceConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.NamespaceConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NamespaceConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NamespaceStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}