package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeAddressBuilder extends NodeAddressFluentImpl<NodeAddressBuilder> implements VisitableBuilder<NodeAddress,io.fabric8.kubernetes.api.model.NodeAddressBuilder>{
  public NodeAddressBuilder() {
    this(false);
  }
  public NodeAddressBuilder(Boolean validationEnabled) {
    this(new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeAddress(), validationEnabled);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAddress instance) {
    this(fluent, instance, false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddress instance) {
    this(instance,false);
  }
  public NodeAddressBuilder(io.fabric8.kubernetes.api.model.NodeAddress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeAddressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeAddress build() {
    NodeAddress buildable = new NodeAddress(fluent.getAddress(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}