package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeAffinityBuilder extends NodeAffinityFluentImpl<NodeAffinityBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NodeAffinity,NodeAffinityBuilder>{
  public NodeAffinityBuilder() {
    this(false);
  }
  public NodeAffinityBuilder(Boolean validationEnabled) {
    this(new NodeAffinity(), validationEnabled);
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeAffinity(), validationEnabled);
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAffinity instance) {
    this(fluent, instance, false);
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeAffinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
    fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinity instance) {
    this(instance,false);
  }
  public NodeAffinityBuilder(io.fabric8.kubernetes.api.model.NodeAffinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
    this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeAffinityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeAffinity build() {
    NodeAffinity buildable = new NodeAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}