package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeBuilder extends NodeFluentImpl<NodeBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Node,NodeBuilder>{
  public NodeBuilder() {
    this(false);
  }
  public NodeBuilder(Boolean validationEnabled) {
    this(new Node(), validationEnabled);
  }
  public NodeBuilder(NodeFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Node(), validationEnabled);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,io.fabric8.kubernetes.api.model.Node instance) {
    this(fluent, instance, false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.NodeFluent<?> fluent,io.fabric8.kubernetes.api.model.Node instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.Node instance) {
    this(instance,false);
  }
  public NodeBuilder(io.fabric8.kubernetes.api.model.Node instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Node build() {
    Node buildable = new Node(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}