package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeConditionBuilder extends NodeConditionFluentImpl<NodeConditionBuilder> implements VisitableBuilder<NodeCondition,io.fabric8.kubernetes.api.model.NodeConditionBuilder>{
  public NodeConditionBuilder() {
    this(false);
  }
  public NodeConditionBuilder(Boolean validationEnabled) {
    this(new NodeCondition(), validationEnabled);
  }
  public NodeConditionBuilder(NodeConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConditionBuilder(io.fabric8.kubernetes.api.model.NodeConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeCondition(), validationEnabled);
  }
  public NodeConditionBuilder(io.fabric8.kubernetes.api.model.NodeConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeCondition instance) {
    this(fluent, instance, false);
  }
  public NodeConditionBuilder(io.fabric8.kubernetes.api.model.NodeConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeConditionBuilder(io.fabric8.kubernetes.api.model.NodeCondition instance) {
    this(instance,false);
  }
  public NodeConditionBuilder(io.fabric8.kubernetes.api.model.NodeCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeCondition build() {
    NodeCondition buildable = new NodeCondition(fluent.getLastHeartbeatTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}