package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeConfigSourceBuilder extends NodeConfigSourceFluentImpl<NodeConfigSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NodeConfigSource,io.fabric8.kubernetes.api.model.NodeConfigSourceBuilder>{
  public NodeConfigSourceBuilder() {
    this(false);
  }
  public NodeConfigSourceBuilder(Boolean validationEnabled) {
    this(new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigSource instance) {
    this(fluent, instance, false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSource instance) {
    this(instance,false);
  }
  public NodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.NodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeConfigSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeConfigSource build() {
    NodeConfigSource buildable = new NodeConfigSource(fluent.getConfigMap());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}