package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeDaemonEndpointsBuilder extends NodeDaemonEndpointsFluentImpl<NodeDaemonEndpointsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NodeDaemonEndpoints,io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder>{
  public NodeDaemonEndpointsBuilder() {
    this(false);
  }
  public NodeDaemonEndpointsBuilder(Boolean validationEnabled) {
    this(new NodeDaemonEndpoints(), validationEnabled);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeDaemonEndpoints(), validationEnabled);
  }
  public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance) {
    this(fluent, instance, false);
  }
  public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubeletEndpoint(instance.getKubeletEndpoint()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance) {
    this(instance,false);
  }
  public NodeDaemonEndpointsBuilder(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeDaemonEndpoints build() {
    NodeDaemonEndpoints buildable = new NodeDaemonEndpoints(fluent.getKubeletEndpoint());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}