package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeListBuilder extends NodeListFluentImpl<NodeListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NodeList,io.fabric8.kubernetes.api.model.NodeListBuilder>{
  public NodeListBuilder() {
    this(false);
  }
  public NodeListBuilder(Boolean validationEnabled) {
    this(new NodeList(), validationEnabled);
  }
  public NodeListBuilder(NodeListFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeListBuilder(io.fabric8.kubernetes.api.model.NodeListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeList(), validationEnabled);
  }
  public NodeListBuilder(io.fabric8.kubernetes.api.model.NodeListFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeList instance) {
    this(fluent, instance, false);
  }
  public NodeListBuilder(io.fabric8.kubernetes.api.model.NodeListFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeListBuilder(io.fabric8.kubernetes.api.model.NodeList instance) {
    this(instance,false);
  }
  public NodeListBuilder(io.fabric8.kubernetes.api.model.NodeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeList build() {
    NodeList buildable = new NodeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}