package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSelectorBuilder extends NodeSelectorFluentImpl<NodeSelectorBuilder> implements VisitableBuilder<NodeSelector,io.fabric8.kubernetes.api.model.NodeSelectorBuilder>{
  public NodeSelectorBuilder() {
    this(false);
  }
  public NodeSelectorBuilder(Boolean validationEnabled) {
    this(new NodeSelector(), validationEnabled);
  }
  public NodeSelectorBuilder(NodeSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeSelector(), validationEnabled);
  }
  public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelector instance) {
    this(fluent, instance, false);
  }
  public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelector instance) {
    this(instance,false);
  }
  public NodeSelectorBuilder(io.fabric8.kubernetes.api.model.NodeSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeSelectorTerms(instance.getNodeSelectorTerms()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeSelector build() {
    NodeSelector buildable = new NodeSelector(fluent.getNodeSelectorTerms());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}