package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSelectorTermBuilder extends NodeSelectorTermFluentImpl<NodeSelectorTermBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.NodeSelectorTerm,NodeSelectorTermBuilder>{
  public NodeSelectorTermBuilder() {
    this(false);
  }
  public NodeSelectorTermBuilder(Boolean validationEnabled) {
    this(new NodeSelectorTerm(), validationEnabled);
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeSelectorTerm(), validationEnabled);
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelectorTerm instance) {
    this(fluent, instance, false);
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSelectorTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchExpressions(instance.getMatchExpressions()); 
    fluent.withMatchFields(instance.getMatchFields()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTerm instance) {
    this(instance,false);
  }
  public NodeSelectorTermBuilder(io.fabric8.kubernetes.api.model.NodeSelectorTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withMatchFields(instance.getMatchFields()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeSelectorTermFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeSelectorTerm build() {
    NodeSelectorTerm buildable = new NodeSelectorTerm(fluent.getMatchExpressions(),fluent.getMatchFields());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}