package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeStatusBuilder extends NodeStatusFluentImpl<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,io.fabric8.kubernetes.api.model.NodeStatusBuilder>{
  public NodeStatusBuilder() {
    this(false);
  }
  public NodeStatusBuilder(Boolean validationEnabled) {
    this(new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeStatus(), validationEnabled);
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeStatus instance) {
    this(fluent, instance, false);
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withAllocatable(instance.getAllocatable()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConfig(instance.getConfig()); 
    fluent.withDaemonEndpoints(instance.getDaemonEndpoints()); 
    fluent.withImages(instance.getImages()); 
    fluent.withNodeInfo(instance.getNodeInfo()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withVolumesAttached(instance.getVolumesAttached()); 
    fluent.withVolumesInUse(instance.getVolumesInUse()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatus instance) {
    this(instance,false);
  }
  public NodeStatusBuilder(io.fabric8.kubernetes.api.model.NodeStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withAllocatable(instance.getAllocatable()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withConfig(instance.getConfig()); 
    this.withDaemonEndpoints(instance.getDaemonEndpoints()); 
    this.withImages(instance.getImages()); 
    this.withNodeInfo(instance.getNodeInfo()); 
    this.withPhase(instance.getPhase()); 
    this.withVolumesAttached(instance.getVolumesAttached()); 
    this.withVolumesInUse(instance.getVolumesInUse()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeStatus build() {
    NodeStatus buildable = new NodeStatus(fluent.getAddresses(),fluent.getAllocatable(),fluent.getCapacity(),fluent.getConditions(),fluent.getConfig(),fluent.getDaemonEndpoints(),fluent.getImages(),fluent.getNodeInfo(),fluent.getPhase(),fluent.getVolumesAttached(),fluent.getVolumesInUse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}