package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSystemInfoBuilder extends NodeSystemInfoFluentImpl<NodeSystemInfoBuilder> implements VisitableBuilder<NodeSystemInfo,io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder>{
  public NodeSystemInfoBuilder() {
    this(false);
  }
  public NodeSystemInfoBuilder(Boolean validationEnabled) {
    this(new NodeSystemInfo(), validationEnabled);
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NodeSystemInfo(), validationEnabled);
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSystemInfo instance) {
    this(fluent, instance, false);
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent<?> fluent,io.fabric8.kubernetes.api.model.NodeSystemInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArchitecture(instance.getArchitecture()); 
    fluent.withBootID(instance.getBootID()); 
    fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion()); 
    fluent.withKernelVersion(instance.getKernelVersion()); 
    fluent.withKubeProxyVersion(instance.getKubeProxyVersion()); 
    fluent.withKubeletVersion(instance.getKubeletVersion()); 
    fluent.withMachineID(instance.getMachineID()); 
    fluent.withOperatingSystem(instance.getOperatingSystem()); 
    fluent.withOsImage(instance.getOsImage()); 
    fluent.withSystemUUID(instance.getSystemUUID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfo instance) {
    this(instance,false);
  }
  public NodeSystemInfoBuilder(io.fabric8.kubernetes.api.model.NodeSystemInfo instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withArchitecture(instance.getArchitecture()); 
    this.withBootID(instance.getBootID()); 
    this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion()); 
    this.withKernelVersion(instance.getKernelVersion()); 
    this.withKubeProxyVersion(instance.getKubeProxyVersion()); 
    this.withKubeletVersion(instance.getKubeletVersion()); 
    this.withMachineID(instance.getMachineID()); 
    this.withOperatingSystem(instance.getOperatingSystem()); 
    this.withOsImage(instance.getOsImage()); 
    this.withSystemUUID(instance.getSystemUUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.NodeSystemInfoFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.NodeSystemInfo build() {
    NodeSystemInfo buildable = new NodeSystemInfo(fluent.getArchitecture(),fluent.getBootID(),fluent.getContainerRuntimeVersion(),fluent.getKernelVersion(),fluent.getKubeProxyVersion(),fluent.getKubeletVersion(),fluent.getMachineID(),fluent.getOperatingSystem(),fluent.getOsImage(),fluent.getSystemUUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}