package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectFieldSelectorBuilder extends ObjectFieldSelectorFluentImpl<ObjectFieldSelectorBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ObjectFieldSelector,io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder>{
  public ObjectFieldSelectorBuilder() {
    this(false);
  }
  public ObjectFieldSelectorBuilder(Boolean validationEnabled) {
    this(new ObjectFieldSelector(), validationEnabled);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ObjectFieldSelector(), validationEnabled);
  }
  public ObjectFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ObjectFieldSelector instance) {
    this(fluent, instance, false);
  }
  public ObjectFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ObjectFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withFieldPath(instance.getFieldPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ObjectFieldSelector instance) {
    this(instance,false);
  }
  public ObjectFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ObjectFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withFieldPath(instance.getFieldPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ObjectFieldSelector build() {
    ObjectFieldSelector buildable = new ObjectFieldSelector(fluent.getApiVersion(),fluent.getFieldPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}