package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OwnerReferenceBuilder extends OwnerReferenceFluentImpl<OwnerReferenceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.OwnerReference,io.fabric8.kubernetes.api.model.OwnerReferenceBuilder>{
  public OwnerReferenceBuilder() {
    this(false);
  }
  public OwnerReferenceBuilder(Boolean validationEnabled) {
    this(new OwnerReference(), validationEnabled);
  }
  public OwnerReferenceBuilder(OwnerReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OwnerReference(), validationEnabled);
  }
  public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.OwnerReference instance) {
    this(fluent, instance, false);
  }
  public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.OwnerReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion()); 
    fluent.withController(instance.getController()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReference instance) {
    this(instance,false);
  }
  public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion()); 
    this.withController(instance.getController()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.OwnerReference build() {
    OwnerReference buildable = new OwnerReference(fluent.getApiVersion(),fluent.getBlockOwnerDeletion(),fluent.getController(),fluent.getKind(),fluent.getName(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}