package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PatchBuilder extends PatchFluentImpl<PatchBuilder> implements VisitableBuilder<Patch,io.fabric8.kubernetes.api.model.PatchBuilder>{
  public PatchBuilder() {
    this(false);
  }
  public PatchBuilder(Boolean validationEnabled) {
    this(new Patch(), validationEnabled);
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.PatchFluent<?> fluent) {
    this(fluent, false);
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.PatchFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Patch(), validationEnabled);
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.PatchFluent<?> fluent,io.fabric8.kubernetes.api.model.Patch instance) {
    this(fluent, instance, false);
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.PatchFluent<?> fluent,io.fabric8.kubernetes.api.model.Patch instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.Patch instance) {
    this(instance,false);
  }
  public PatchBuilder(io.fabric8.kubernetes.api.model.Patch instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PatchFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Patch build() {
    Patch buildable = new Patch();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}