package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PatchOptionsBuilder extends PatchOptionsFluentImpl<PatchOptionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PatchOptions,io.fabric8.kubernetes.api.model.PatchOptionsBuilder>{
  public PatchOptionsBuilder() {
    this(false);
  }
  public PatchOptionsBuilder(Boolean validationEnabled) {
    this(new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(PatchOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PatchOptions instance) {
    this(fluent, instance, false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PatchOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDryRun(instance.getDryRun()); 
    fluent.withFieldManager(instance.getFieldManager()); 
    fluent.withFieldValidation(instance.getFieldValidation()); 
    fluent.withForce(instance.getForce()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptions instance) {
    this(instance,false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withFieldManager(instance.getFieldManager()); 
    this.withFieldValidation(instance.getFieldValidation()); 
    this.withForce(instance.getForce()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PatchOptions build() {
    PatchOptions buildable = new PatchOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getForce(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}