package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimListBuilder extends PersistentVolumeClaimListFluentImpl<PersistentVolumeClaimListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PersistentVolumeClaimList,PersistentVolumeClaimListBuilder>{
  public PersistentVolumeClaimListBuilder() {
    this(false);
  }
  public PersistentVolumeClaimListBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimList(), validationEnabled);
  }
  public PersistentVolumeClaimListBuilder(PersistentVolumeClaimListFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimList(), validationEnabled);
  }
  public PersistentVolumeClaimListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimList instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimList build() {
    PersistentVolumeClaimList buildable = new PersistentVolumeClaimList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}