package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeClaimSpecFluent<A>{
  public PersistentVolumeClaimSpecFluentImpl() {
  }
  public PersistentVolumeClaimSpecFluentImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec instance) {
    this.withAccessModes(instance.getAccessModes()); 
    this.withDataSource(instance.getDataSource()); 
    this.withDataSourceRef(instance.getDataSourceRef()); 
    this.withResources(instance.getResources()); 
    this.withSelector(instance.getSelector()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withVolumeMode(instance.getVolumeMode()); 
    this.withVolumeName(instance.getVolumeName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> accessModes = new ArrayList<java.lang.String>();
  private TypedLocalObjectReferenceBuilder dataSource;
  private TypedLocalObjectReferenceBuilder dataSourceRef;
  private ResourceRequirementsBuilder resources;
  private LabelSelectorBuilder selector;
  private java.lang.String storageClassName;
  private java.lang.String volumeMode;
  private java.lang.String volumeName;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToAccessModes(Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(java.lang.Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(Collection<java.lang.String> items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAccessModes() {
    return this.accessModes;
  }
  public java.lang.String getAccessMode(java.lang.Integer index) {
    return this.accessModes.get(index);
  }
  public java.lang.String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public java.lang.String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public java.lang.String getMatchingAccessMode(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAccessMode(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(java.util.List<java.lang.String> accessModes) {
    if (accessModes != null) {this.accessModes = new java.util.ArrayList(); for (java.lang.String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear();}
    if (accessModes != null) {for (java.lang.String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildDataSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference getDataSource() {
    return this.dataSource!=null ?this.dataSource.build():null;
  }
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference buildDataSource() {
    return this.dataSource!=null ?this.dataSource.build():null;
  }
  public A withDataSource(io.fabric8.kubernetes.api.model.TypedLocalObjectReference dataSource) {
    _visitables.get("dataSource").remove(this.dataSource);
    if (dataSource!=null){ this.dataSource= new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder(dataSource); _visitables.get("dataSource").add(this.dataSource);} return (A) this;
  }
  public java.lang.Boolean hasDataSource() {
    return this.dataSource != null;
  }
  public A withNewDataSource(java.lang.String apiGroup,java.lang.String kind,java.lang.String name) {
    return (A)withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(io.fabric8.kubernetes.api.model.TypedLocalObjectReference item) {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
    return withNewDataSourceLike(getDataSource());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
    return withNewDataSourceLike(getDataSource() != null ? getDataSource(): new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(io.fabric8.kubernetes.api.model.TypedLocalObjectReference item) {
    return withNewDataSourceLike(getDataSource() != null ? getDataSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDataSourceRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference getDataSourceRef() {
    return this.dataSourceRef!=null ?this.dataSourceRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.TypedLocalObjectReference buildDataSourceRef() {
    return this.dataSourceRef!=null ?this.dataSourceRef.build():null;
  }
  public A withDataSourceRef(io.fabric8.kubernetes.api.model.TypedLocalObjectReference dataSourceRef) {
    _visitables.get("dataSourceRef").remove(this.dataSourceRef);
    if (dataSourceRef!=null){ this.dataSourceRef= new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder(dataSourceRef); _visitables.get("dataSourceRef").add(this.dataSourceRef);} return (A) this;
  }
  public java.lang.Boolean hasDataSourceRef() {
    return this.dataSourceRef != null;
  }
  public A withNewDataSourceRef(java.lang.String apiGroup,java.lang.String kind,java.lang.String name) {
    return (A)withDataSourceRef(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRef() {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRefLike(io.fabric8.kubernetes.api.model.TypedLocalObjectReference item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentImpl.DataSourceRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editDataSourceRef() {
    return withNewDataSourceRefLike(getDataSourceRef());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRef() {
    return withNewDataSourceRefLike(getDataSourceRef() != null ? getDataSourceRef(): new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRefLike(io.fabric8.kubernetes.api.model.TypedLocalObjectReference item) {
    return withNewDataSourceRefLike(getDataSourceRef() != null ? getDataSourceRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return this.resources != null;
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
    return new PersistentVolumeClaimSpecFluentImpl.ResourcesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
    return new PersistentVolumeClaimSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public java.lang.String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(java.lang.String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public java.lang.Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  public java.lang.String getVolumeMode() {
    return this.volumeMode;
  }
  public A withVolumeMode(java.lang.String volumeMode) {
    this.volumeMode=volumeMode; return (A) this;
  }
  public java.lang.Boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  public java.lang.String getVolumeName() {
    return this.volumeName;
  }
  public A withVolumeName(java.lang.String volumeName) {
    this.volumeName=volumeName; return (A) this;
  }
  public java.lang.Boolean hasVolumeName() {
    return this.volumeName != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl) o;
    if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
    if (dataSource != null ? !dataSource.equals(that.dataSource) :that.dataSource != null) return false;
    if (dataSourceRef != null ? !dataSourceRef.equals(that.dataSourceRef) :that.dataSourceRef != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (storageClassName != null ? !storageClassName.equals(that.storageClassName) :that.storageClassName != null) return false;
    if (volumeMode != null ? !volumeMode.equals(that.volumeMode) :that.volumeMode != null) return false;
    if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  dataSource,  dataSourceRef,  resources,  selector,  storageClassName,  volumeMode,  volumeName,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (dataSource != null) { sb.append("dataSource:"); sb.append(dataSource + ","); }
    if (dataSourceRef != null) { sb.append("dataSourceRef:"); sb.append(dataSourceRef + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DataSourceNestedImpl<N> extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceNested<N>,Nested<N>{
    DataSourceNestedImpl(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    DataSourceNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withDataSource(builder.build());
    }
    public N endDataSource() {
      return and();
    }
    
  }
  class DataSourceRefNestedImpl<N> extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DataSourceRefNestedImpl(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    DataSourceRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withDataSourceRef(builder.build());
    }
    public N endDataSourceRef() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourcesNestedImpl(io.fabric8.kubernetes.api.model.ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PersistentVolumeClaimSpecFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}