package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimStatusBuilder extends PersistentVolumeClaimStatusFluentImpl<PersistentVolumeClaimStatusBuilder> implements VisitableBuilder<PersistentVolumeClaimStatus,io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusBuilder>{
  public PersistentVolumeClaimStatusBuilder() {
    this(false);
  }
  public PersistentVolumeClaimStatusBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimStatus(), validationEnabled);
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimStatus(), validationEnabled);
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAccessModes(instance.getAccessModes()); 
    fluent.withAllocatedResources(instance.getAllocatedResources()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withResizeStatus(instance.getResizeStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAccessModes(instance.getAccessModes()); 
    this.withAllocatedResources(instance.getAllocatedResources()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withResizeStatus(instance.getResizeStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus build() {
    PersistentVolumeClaimStatus buildable = new PersistentVolumeClaimStatus(fluent.getAccessModes(),fluent.getAllocatedResources(),fluent.getCapacity(),fluent.getConditions(),fluent.getPhase(),fluent.getResizeStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}