package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentVolumeClaimStatusFluentImpl<A extends PersistentVolumeClaimStatusFluent<A>> extends BaseFluent<A> implements PersistentVolumeClaimStatusFluent<A>{
  public PersistentVolumeClaimStatusFluentImpl() {
  }
  public PersistentVolumeClaimStatusFluentImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus instance) {
    this.withAccessModes(instance.getAccessModes()); 
    this.withAllocatedResources(instance.getAllocatedResources()); 
    this.withCapacity(instance.getCapacity()); 
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withResizeStatus(instance.getResizeStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> accessModes = new ArrayList<java.lang.String>();
  private Map<java.lang.String,Quantity> allocatedResources;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity;
  private java.util.ArrayList<PersistentVolumeClaimConditionBuilder> conditions = new java.util.ArrayList<PersistentVolumeClaimConditionBuilder>();
  private java.lang.String phase;
  private java.lang.String resizeStatus;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public A addToAccessModes(Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(java.lang.Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(Collection<java.lang.String> items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAccessModes() {
    return this.accessModes;
  }
  public java.lang.String getAccessMode(java.lang.Integer index) {
    return this.accessModes.get(index);
  }
  public java.lang.String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public java.lang.String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public java.lang.String getMatchingAccessMode(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAccessMode(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(java.util.List<java.lang.String> accessModes) {
    if (accessModes != null) {this.accessModes = new java.util.ArrayList(); for (java.lang.String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear();}
    if (accessModes != null) {for (java.lang.String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  public A addToAllocatedResources(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.allocatedResources == null && key != null && value != null) { this.allocatedResources = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocatedResources.put(key, value);} return (A)this;
  }
  public A addToAllocatedResources(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatedResources == null && map != null) { this.allocatedResources = new java.util.LinkedHashMap(); }
    if(map != null) { this.allocatedResources.putAll(map);} return (A)this;
  }
  public A removeFromAllocatedResources(java.lang.String key) {
    if(this.allocatedResources == null) { return (A) this; }
    if(key != null && this.allocatedResources != null) {this.allocatedResources.remove(key);} return (A)this;
  }
  public A removeFromAllocatedResources(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.allocatedResources == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatedResources != null){this.allocatedResources.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getAllocatedResources() {
    return this.allocatedResources;
  }
  public <K,V>A withAllocatedResources(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> allocatedResources) {
    if (allocatedResources == null) { this.allocatedResources =  null;} else {this.allocatedResources = new java.util.LinkedHashMap(allocatedResources);} return (A) this;
  }
  public java.lang.Boolean hasAllocatedResources() {
    return this.allocatedResources != null;
  }
  public A addToCapacity(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(java.lang.String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new java.util.LinkedHashMap(capacity);} return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition() {
    return new PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    return new PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  public java.lang.String getResizeStatus() {
    return this.resizeStatus;
  }
  public A withResizeStatus(java.lang.String resizeStatus) {
    this.resizeStatus=resizeStatus; return (A) this;
  }
  public java.lang.Boolean hasResizeStatus() {
    return this.resizeStatus != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PersistentVolumeClaimStatusFluentImpl that = (PersistentVolumeClaimStatusFluentImpl) o;
    if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
    if (allocatedResources != null ? !allocatedResources.equals(that.allocatedResources) :that.allocatedResources != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (resizeStatus != null ? !resizeStatus.equals(that.resizeStatus) :that.resizeStatus != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  allocatedResources,  capacity,  conditions,  phase,  resizeStatus,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (allocatedResources != null && !allocatedResources.isEmpty()) { sb.append("allocatedResources:"); sb.append(allocatedResources + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (resizeStatus != null) { sb.append("resizeStatus:"); sb.append(resizeStatus + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends PersistentVolumeClaimConditionFluentImpl<PersistentVolumeClaimStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaimCondition item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PersistentVolumeClaimStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}