package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimVolumeSourceBuilder extends PersistentVolumeClaimVolumeSourceFluentImpl<PersistentVolumeClaimVolumeSourceBuilder> implements VisitableBuilder<PersistentVolumeClaimVolumeSource,io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder>{
  public PersistentVolumeClaimVolumeSourceBuilder() {
    this(false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimVolumeSource(), validationEnabled);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimVolumeSource(), validationEnabled);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClaimName(instance.getClaimName()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClaimName(instance.getClaimName()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource build() {
    PersistentVolumeClaimVolumeSource buildable = new PersistentVolumeClaimVolumeSource(fluent.getClaimName(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}