package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeListBuilder extends PersistentVolumeListFluentImpl<PersistentVolumeListBuilder> implements VisitableBuilder<PersistentVolumeList,io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder>{
  public PersistentVolumeListBuilder() {
    this(false);
  }
  public PersistentVolumeListBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeList(), validationEnabled);
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolumeList(), validationEnabled);
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeList instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeList instance) {
    this(instance,false);
  }
  public PersistentVolumeListBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolumeList build() {
    PersistentVolumeList buildable = new PersistentVolumeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}