package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeSpecFluent<A>{
  public PersistentVolumeSpecFluentImpl() {
  }
  public PersistentVolumeSpecFluentImpl(io.fabric8.kubernetes.api.model.PersistentVolumeSpec instance) {
    this.withAccessModes(instance.getAccessModes()); 
    this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
    this.withAzureDisk(instance.getAzureDisk()); 
    this.withAzureFile(instance.getAzureFile()); 
    this.withCapacity(instance.getCapacity()); 
    this.withCephfs(instance.getCephfs()); 
    this.withCinder(instance.getCinder()); 
    this.withClaimRef(instance.getClaimRef()); 
    this.withCsi(instance.getCsi()); 
    this.withFc(instance.getFc()); 
    this.withFlexVolume(instance.getFlexVolume()); 
    this.withFlocker(instance.getFlocker()); 
    this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
    this.withGlusterfs(instance.getGlusterfs()); 
    this.withHostPath(instance.getHostPath()); 
    this.withIscsi(instance.getIscsi()); 
    this.withLocal(instance.getLocal()); 
    this.withMountOptions(instance.getMountOptions()); 
    this.withNfs(instance.getNfs()); 
    this.withNodeAffinity(instance.getNodeAffinity()); 
    this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); 
    this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk()); 
    this.withPortworxVolume(instance.getPortworxVolume()); 
    this.withQuobyte(instance.getQuobyte()); 
    this.withRbd(instance.getRbd()); 
    this.withScaleIO(instance.getScaleIO()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withStorageos(instance.getStorageos()); 
    this.withVolumeMode(instance.getVolumeMode()); 
    this.withVsphereVolume(instance.getVsphereVolume()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> accessModes = new ArrayList<java.lang.String>();
  private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
  private AzureDiskVolumeSourceBuilder azureDisk;
  private AzureFilePersistentVolumeSourceBuilder azureFile;
  private Map<java.lang.String,Quantity> capacity;
  private CephFSPersistentVolumeSourceBuilder cephfs;
  private CinderPersistentVolumeSourceBuilder cinder;
  private ObjectReferenceBuilder claimRef;
  private CSIPersistentVolumeSourceBuilder csi;
  private FCVolumeSourceBuilder fc;
  private FlexPersistentVolumeSourceBuilder flexVolume;
  private FlockerVolumeSourceBuilder flocker;
  private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
  private GlusterfsPersistentVolumeSourceBuilder glusterfs;
  private HostPathVolumeSourceBuilder hostPath;
  private ISCSIPersistentVolumeSourceBuilder iscsi;
  private LocalVolumeSourceBuilder local;
  private java.util.List<java.lang.String> mountOptions = new java.util.ArrayList<java.lang.String>();
  private NFSVolumeSourceBuilder nfs;
  private VolumeNodeAffinityBuilder nodeAffinity;
  private java.lang.String persistentVolumeReclaimPolicy;
  private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
  private PortworxVolumeSourceBuilder portworxVolume;
  private QuobyteVolumeSourceBuilder quobyte;
  private RBDPersistentVolumeSourceBuilder rbd;
  private ScaleIOPersistentVolumeSourceBuilder scaleIO;
  private java.lang.String storageClassName;
  private StorageOSPersistentVolumeSourceBuilder storageos;
  private java.lang.String volumeMode;
  private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public A addToAccessModes(Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(java.lang.Integer index,java.lang.String item) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(Collection<java.lang.String> items) {
    if (this.accessModes == null) {this.accessModes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAccessModes() {
    return this.accessModes;
  }
  public java.lang.String getAccessMode(java.lang.Integer index) {
    return this.accessModes.get(index);
  }
  public java.lang.String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public java.lang.String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public java.lang.String getMatchingAccessMode(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAccessMode(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(java.util.List<java.lang.String> accessModes) {
    if (accessModes != null) {this.accessModes = new java.util.ArrayList(); for (java.lang.String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear();}
    if (accessModes != null) {for (java.lang.String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public java.lang.Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAwsElasticBlockStore instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null ?this.awsElasticBlockStore.build():null;
  }
  public io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null ?this.awsElasticBlockStore.build():null;
  }
  public A withAwsElasticBlockStore(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore);
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.get("awsElasticBlockStore").add(this.awsElasticBlockStore);} return (A) this;
  }
  public java.lang.Boolean hasAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null;
  }
  public A withNewAwsElasticBlockStore(java.lang.String fsType,java.lang.Integer partition,java.lang.Boolean readOnly,java.lang.String volumeID) {
    return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
    return new PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource item) {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource getAzureDisk() {
    return this.azureDisk!=null ?this.azureDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.AzureDiskVolumeSource buildAzureDisk() {
    return this.azureDisk!=null ?this.azureDisk.build():null;
  }
  public A withAzureDisk(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource azureDisk) {
    _visitables.get("azureDisk").remove(this.azureDisk);
    if (azureDisk!=null){ this.azureDisk= new AzureDiskVolumeSourceBuilder(azureDisk); _visitables.get("azureDisk").add(this.azureDisk);} return (A) this;
  }
  public java.lang.Boolean hasAzureDisk() {
    return this.azureDisk != null;
  }
  public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDisk() {
    return new PersistentVolumeSpecFluentImpl.AzureDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDiskLike(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.AzureDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureDiskNested<A> editAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDiskLike(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureFile instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource getAzureFile() {
    return this.azureFile!=null ?this.azureFile.build():null;
  }
  public io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource buildAzureFile() {
    return this.azureFile!=null ?this.azureFile.build():null;
  }
  public A withAzureFile(io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource azureFile) {
    _visitables.get("azureFile").remove(this.azureFile);
    if (azureFile!=null){ this.azureFile= new AzureFilePersistentVolumeSourceBuilder(azureFile); _visitables.get("azureFile").add(this.azureFile);} return (A) this;
  }
  public java.lang.Boolean hasAzureFile() {
    return this.azureFile != null;
  }
  public A withNewAzureFile(java.lang.Boolean readOnly,java.lang.String secretName,java.lang.String secretNamespace,java.lang.String shareName) {
    return (A)withAzureFile(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile() {
    return new PersistentVolumeSpecFluentImpl.AzureFileNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.AzureFileNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile() {
    return withNewAzureFileLike(getAzureFile());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile() {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): new io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSource item) {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): item);
  }
  public A addToCapacity(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new java.util.LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(java.lang.String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new java.util.LinkedHashMap(capacity);} return (A) this;
  }
  public java.lang.Boolean hasCapacity() {
    return this.capacity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCephfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public CephFSPersistentVolumeSource getCephfs() {
    return this.cephfs!=null ?this.cephfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource buildCephfs() {
    return this.cephfs!=null ?this.cephfs.build():null;
  }
  public A withCephfs(io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource cephfs) {
    _visitables.get("cephfs").remove(this.cephfs);
    if (cephfs!=null){ this.cephfs= new io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceBuilder(cephfs); _visitables.get("cephfs").add(this.cephfs);} return (A) this;
  }
  public java.lang.Boolean hasCephfs() {
    return this.cephfs != null;
  }
  public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs() {
    return new PersistentVolumeSpecFluentImpl.CephfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.CephfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CephfsNested<A> editCephfs() {
    return withNewCephfsLike(getCephfs());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs() {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): new io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource item) {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCinder instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource getCinder() {
    return this.cinder!=null ?this.cinder.build():null;
  }
  public io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource buildCinder() {
    return this.cinder!=null ?this.cinder.build():null;
  }
  public A withCinder(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource cinder) {
    _visitables.get("cinder").remove(this.cinder);
    if (cinder!=null){ this.cinder= new CinderPersistentVolumeSourceBuilder(cinder); _visitables.get("cinder").add(this.cinder);} return (A) this;
  }
  public java.lang.Boolean hasCinder() {
    return this.cinder != null;
  }
  public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder() {
    return new PersistentVolumeSpecFluentImpl.CinderNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.CinderNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CinderNested<A> editCinder() {
    return withNewCinderLike(getCinder());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder() {
    return withNewCinderLike(getCinder() != null ? getCinder(): new io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource item) {
    return withNewCinderLike(getCinder() != null ? getCinder(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClaimRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getClaimRef() {
    return this.claimRef!=null ?this.claimRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildClaimRef() {
    return this.claimRef!=null ?this.claimRef.build():null;
  }
  public A withClaimRef(io.fabric8.kubernetes.api.model.ObjectReference claimRef) {
    _visitables.get("claimRef").remove(this.claimRef);
    if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.get("claimRef").add(this.claimRef);} return (A) this;
  }
  public java.lang.Boolean hasClaimRef() {
    return this.claimRef != null;
  }
  public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef() {
    return new PersistentVolumeSpecFluentImpl.ClaimRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.ClaimRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef() {
    return withNewClaimRefLike(getClaimRef());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef() {
    return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCsi instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource getCsi() {
    return this.csi!=null ?this.csi.build():null;
  }
  public io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource buildCsi() {
    return this.csi!=null ?this.csi.build():null;
  }
  public A withCsi(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource csi) {
    _visitables.get("csi").remove(this.csi);
    if (csi!=null){ this.csi= new CSIPersistentVolumeSourceBuilder(csi); _visitables.get("csi").add(this.csi);} return (A) this;
  }
  public java.lang.Boolean hasCsi() {
    return this.csi != null;
  }
  public PersistentVolumeSpecFluent.CsiNested<A> withNewCsi() {
    return new PersistentVolumeSpecFluentImpl.CsiNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CsiNested<A> withNewCsiLike(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.CsiNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CsiNested<A> editCsi() {
    return withNewCsiLike(getCsi());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CsiNested<A> editOrNewCsi() {
    return withNewCsiLike(getCsi() != null ? getCsi(): new io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CsiNested<A> editOrNewCsiLike(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource item) {
    return withNewCsiLike(getCsi() != null ? getCsi(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFc instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FCVolumeSource getFc() {
    return this.fc!=null ?this.fc.build():null;
  }
  public io.fabric8.kubernetes.api.model.FCVolumeSource buildFc() {
    return this.fc!=null ?this.fc.build():null;
  }
  public A withFc(io.fabric8.kubernetes.api.model.FCVolumeSource fc) {
    _visitables.get("fc").remove(this.fc);
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.get("fc").add(this.fc);} return (A) this;
  }
  public java.lang.Boolean hasFc() {
    return this.fc != null;
  }
  public PersistentVolumeSpecFluent.FcNested<A> withNewFc() {
    return new PersistentVolumeSpecFluentImpl.FcNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(io.fabric8.kubernetes.api.model.FCVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.FcNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FcNested<A> editFc() {
    return withNewFcLike(getFc());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FcNested<A> editOrNewFc() {
    return withNewFcLike(getFc() != null ? getFc(): new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(io.fabric8.kubernetes.api.model.FCVolumeSource item) {
    return withNewFcLike(getFc() != null ? getFc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlexVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource getFlexVolume() {
    return this.flexVolume!=null ?this.flexVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource buildFlexVolume() {
    return this.flexVolume!=null ?this.flexVolume.build():null;
  }
  public A withFlexVolume(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource flexVolume) {
    _visitables.get("flexVolume").remove(this.flexVolume);
    if (flexVolume!=null){ this.flexVolume= new FlexPersistentVolumeSourceBuilder(flexVolume); _visitables.get("flexVolume").add(this.flexVolume);} return (A) this;
  }
  public java.lang.Boolean hasFlexVolume() {
    return this.flexVolume != null;
  }
  public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume() {
    return new PersistentVolumeSpecFluentImpl.FlexVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.FlexVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): new io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource item) {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlocker instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.FlockerVolumeSource getFlocker() {
    return this.flocker!=null ?this.flocker.build():null;
  }
  public io.fabric8.kubernetes.api.model.FlockerVolumeSource buildFlocker() {
    return this.flocker!=null ?this.flocker.build():null;
  }
  public A withFlocker(io.fabric8.kubernetes.api.model.FlockerVolumeSource flocker) {
    _visitables.get("flocker").remove(this.flocker);
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.get("flocker").add(this.flocker);} return (A) this;
  }
  public java.lang.Boolean hasFlocker() {
    return this.flocker != null;
  }
  public A withNewFlocker(java.lang.String datasetName,java.lang.String datasetUUID) {
    return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker() {
    return new PersistentVolumeSpecFluentImpl.FlockerNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.FlockerNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlockerNested<A> editFlocker() {
    return withNewFlockerLike(getFlocker());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker() {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcePersistentDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource getGcePersistentDisk() {
    return this.gcePersistentDisk!=null ?this.gcePersistentDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
    return this.gcePersistentDisk!=null ?this.gcePersistentDisk.build():null;
  }
  public A withGcePersistentDisk(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource gcePersistentDisk) {
    _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk);
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.get("gcePersistentDisk").add(this.gcePersistentDisk);} return (A) this;
  }
  public java.lang.Boolean hasGcePersistentDisk() {
    return this.gcePersistentDisk != null;
  }
  public A withNewGcePersistentDisk(java.lang.String fsType,java.lang.Integer partition,java.lang.String pdName,java.lang.Boolean readOnly) {
    return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
    return new PersistentVolumeSpecFluentImpl.GcePersistentDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.GcePersistentDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource item) {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlusterfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public GlusterfsPersistentVolumeSource getGlusterfs() {
    return this.glusterfs!=null ?this.glusterfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource buildGlusterfs() {
    return this.glusterfs!=null ?this.glusterfs.build():null;
  }
  public A withGlusterfs(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource glusterfs) {
    _visitables.get("glusterfs").remove(this.glusterfs);
    if (glusterfs!=null){ this.glusterfs= new io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder(glusterfs); _visitables.get("glusterfs").add(this.glusterfs);} return (A) this;
  }
  public java.lang.Boolean hasGlusterfs() {
    return this.glusterfs != null;
  }
  public A withNewGlusterfs(java.lang.String endpoints,java.lang.String endpointsNamespace,java.lang.String path,java.lang.Boolean readOnly) {
    return (A)withGlusterfs(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs() {
    return new PersistentVolumeSpecFluentImpl.GlusterfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.GlusterfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): new io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource item) {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHostPath instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HostPathVolumeSource getHostPath() {
    return this.hostPath!=null ?this.hostPath.build():null;
  }
  public io.fabric8.kubernetes.api.model.HostPathVolumeSource buildHostPath() {
    return this.hostPath!=null ?this.hostPath.build():null;
  }
  public A withHostPath(io.fabric8.kubernetes.api.model.HostPathVolumeSource hostPath) {
    _visitables.get("hostPath").remove(this.hostPath);
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.get("hostPath").add(this.hostPath);} return (A) this;
  }
  public java.lang.Boolean hasHostPath() {
    return this.hostPath != null;
  }
  public A withNewHostPath(java.lang.String path,java.lang.String type) {
    return (A)withHostPath(new HostPathVolumeSource(path, type));
  }
  public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath() {
    return new PersistentVolumeSpecFluentImpl.HostPathNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(io.fabric8.kubernetes.api.model.HostPathVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.HostPathNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.HostPathNested<A> editHostPath() {
    return withNewHostPathLike(getHostPath());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath() {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(io.fabric8.kubernetes.api.model.HostPathVolumeSource item) {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIscsi instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource getIscsi() {
    return this.iscsi!=null ?this.iscsi.build():null;
  }
  public io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource buildIscsi() {
    return this.iscsi!=null ?this.iscsi.build():null;
  }
  public A withIscsi(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource iscsi) {
    _visitables.get("iscsi").remove(this.iscsi);
    if (iscsi!=null){ this.iscsi= new ISCSIPersistentVolumeSourceBuilder(iscsi); _visitables.get("iscsi").add(this.iscsi);} return (A) this;
  }
  public java.lang.Boolean hasIscsi() {
    return this.iscsi != null;
  }
  public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi() {
    return new PersistentVolumeSpecFluentImpl.IscsiNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.IscsiNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.IscsiNested<A> editIscsi() {
    return withNewIscsiLike(getIscsi());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi() {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): new io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource item) {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLocal instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalVolumeSource getLocal() {
    return this.local!=null ?this.local.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalVolumeSource buildLocal() {
    return this.local!=null ?this.local.build():null;
  }
  public A withLocal(io.fabric8.kubernetes.api.model.LocalVolumeSource local) {
    _visitables.get("local").remove(this.local);
    if (local!=null){ this.local= new io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder(local); _visitables.get("local").add(this.local);} return (A) this;
  }
  public java.lang.Boolean hasLocal() {
    return this.local != null;
  }
  public A withNewLocal(java.lang.String fsType,java.lang.String path) {
    return (A)withLocal(new LocalVolumeSource(fsType, path));
  }
  public PersistentVolumeSpecFluent.LocalNested<A> withNewLocal() {
    return new PersistentVolumeSpecFluentImpl.LocalNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.LocalNested<A> withNewLocalLike(io.fabric8.kubernetes.api.model.LocalVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.LocalNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.LocalNested<A> editLocal() {
    return withNewLocalLike(getLocal());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.LocalNested<A> editOrNewLocal() {
    return withNewLocalLike(getLocal() != null ? getLocal(): new io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.LocalNested<A> editOrNewLocalLike(io.fabric8.kubernetes.api.model.LocalVolumeSource item) {
    return withNewLocalLike(getLocal() != null ? getLocal(): item);
  }
  public A addToMountOptions(java.lang.Integer index,java.lang.String item) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    this.mountOptions.add(index, item);
    return (A)this;
  }
  public A setToMountOptions(java.lang.Integer index,java.lang.String item) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    this.mountOptions.set(index, item); return (A)this;
  }
  public A addToMountOptions(java.lang.String... items) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A addAllToMountOptions(java.util.Collection<java.lang.String> items) {
    if (this.mountOptions == null) {this.mountOptions = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A removeFromMountOptions(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromMountOptions(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getMountOptions() {
    return this.mountOptions;
  }
  public java.lang.String getMountOption(java.lang.Integer index) {
    return this.mountOptions.get(index);
  }
  public java.lang.String getFirstMountOption() {
    return this.mountOptions.get(0);
  }
  public java.lang.String getLastMountOption() {
    return this.mountOptions.get(mountOptions.size() - 1);
  }
  public java.lang.String getMatchingMountOption(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: mountOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingMountOption(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: mountOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMountOptions(java.util.List<java.lang.String> mountOptions) {
    if (mountOptions != null) {this.mountOptions = new java.util.ArrayList(); for (java.lang.String item : mountOptions){this.addToMountOptions(item);}} else { this.mountOptions = null;} return (A) this;
  }
  public A withMountOptions(java.lang.String... mountOptions) {
    if (this.mountOptions != null) {this.mountOptions.clear();}
    if (mountOptions != null) {for (java.lang.String item :mountOptions){ this.addToMountOptions(item);}} return (A) this;
  }
  public java.lang.Boolean hasMountOptions() {
    return mountOptions != null && !mountOptions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildNfs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public NFSVolumeSource getNfs() {
    return this.nfs!=null ?this.nfs.build():null;
  }
  public io.fabric8.kubernetes.api.model.NFSVolumeSource buildNfs() {
    return this.nfs!=null ?this.nfs.build():null;
  }
  public A withNfs(io.fabric8.kubernetes.api.model.NFSVolumeSource nfs) {
    _visitables.get("nfs").remove(this.nfs);
    if (nfs!=null){ this.nfs= new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder(nfs); _visitables.get("nfs").add(this.nfs);} return (A) this;
  }
  public java.lang.Boolean hasNfs() {
    return this.nfs != null;
  }
  public A withNewNfs(java.lang.String path,java.lang.Boolean readOnly,java.lang.String server) {
    return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
  }
  public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs() {
    return new PersistentVolumeSpecFluentImpl.NfsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(io.fabric8.kubernetes.api.model.NFSVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.NfsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NfsNested<A> editNfs() {
    return withNewNfsLike(getNfs());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs() {
    return withNewNfsLike(getNfs() != null ? getNfs(): new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(io.fabric8.kubernetes.api.model.NFSVolumeSource item) {
    return withNewNfsLike(getNfs() != null ? getNfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeAffinity instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.VolumeNodeAffinity getNodeAffinity() {
    return this.nodeAffinity!=null ?this.nodeAffinity.build():null;
  }
  public io.fabric8.kubernetes.api.model.VolumeNodeAffinity buildNodeAffinity() {
    return this.nodeAffinity!=null ?this.nodeAffinity.build():null;
  }
  public A withNodeAffinity(io.fabric8.kubernetes.api.model.VolumeNodeAffinity nodeAffinity) {
    _visitables.get("nodeAffinity").remove(this.nodeAffinity);
    if (nodeAffinity!=null){ this.nodeAffinity= new VolumeNodeAffinityBuilder(nodeAffinity); _visitables.get("nodeAffinity").add(this.nodeAffinity);} return (A) this;
  }
  public java.lang.Boolean hasNodeAffinity() {
    return this.nodeAffinity != null;
  }
  public PersistentVolumeSpecFluent.NodeAffinityNested<A> withNewNodeAffinity() {
    return new PersistentVolumeSpecFluentImpl.NodeAffinityNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NodeAffinityNested<A> withNewNodeAffinityLike(io.fabric8.kubernetes.api.model.VolumeNodeAffinity item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.NodeAffinityNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NodeAffinityNested<A> editNodeAffinity() {
    return withNewNodeAffinityLike(getNodeAffinity());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NodeAffinityNested<A> editOrNewNodeAffinity() {
    return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): new io.fabric8.kubernetes.api.model.VolumeNodeAffinityBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NodeAffinityNested<A> editOrNewNodeAffinityLike(io.fabric8.kubernetes.api.model.VolumeNodeAffinity item) {
    return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): item);
  }
  public java.lang.String getPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy;
  }
  public A withPersistentVolumeReclaimPolicy(java.lang.String persistentVolumeReclaimPolicy) {
    this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (A) this;
  }
  public java.lang.Boolean hasPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPhotonPersistentDisk instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PhotonPersistentDiskVolumeSource getPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null ?this.photonPersistentDisk.build():null;
  }
  public io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null ?this.photonPersistentDisk.build():null;
  }
  public A withPhotonPersistentDisk(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource photonPersistentDisk) {
    _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk);
    if (photonPersistentDisk!=null){ this.photonPersistentDisk= new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk); _visitables.get("photonPersistentDisk").add(this.photonPersistentDisk);} return (A) this;
  }
  public java.lang.Boolean hasPhotonPersistentDisk() {
    return this.photonPersistentDisk != null;
  }
  public A withNewPhotonPersistentDisk(java.lang.String fsType,java.lang.String pdID) {
    return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
    return new PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPortworxVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PortworxVolumeSource getPortworxVolume() {
    return this.portworxVolume!=null ?this.portworxVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.PortworxVolumeSource buildPortworxVolume() {
    return this.portworxVolume!=null ?this.portworxVolume.build():null;
  }
  public A withPortworxVolume(io.fabric8.kubernetes.api.model.PortworxVolumeSource portworxVolume) {
    _visitables.get("portworxVolume").remove(this.portworxVolume);
    if (portworxVolume!=null){ this.portworxVolume= new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder(portworxVolume); _visitables.get("portworxVolume").add(this.portworxVolume);} return (A) this;
  }
  public java.lang.Boolean hasPortworxVolume() {
    return this.portworxVolume != null;
  }
  public A withNewPortworxVolume(java.lang.String fsType,java.lang.Boolean readOnly,java.lang.String volumeID) {
    return (A)withPortworxVolume(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public PersistentVolumeSpecFluent.PortworxVolumeNested<A> withNewPortworxVolume() {
    return new PersistentVolumeSpecFluentImpl.PortworxVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PortworxVolumeNested<A> withNewPortworxVolumeLike(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.PortworxVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PortworxVolumeNested<A> editPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PortworxVolumeNested<A> editOrNewPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PortworxVolumeNested<A> editOrNewPortworxVolumeLike(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuobyte instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.QuobyteVolumeSource getQuobyte() {
    return this.quobyte!=null ?this.quobyte.build():null;
  }
  public io.fabric8.kubernetes.api.model.QuobyteVolumeSource buildQuobyte() {
    return this.quobyte!=null ?this.quobyte.build():null;
  }
  public A withQuobyte(io.fabric8.kubernetes.api.model.QuobyteVolumeSource quobyte) {
    _visitables.get("quobyte").remove(this.quobyte);
    if (quobyte!=null){ this.quobyte= new QuobyteVolumeSourceBuilder(quobyte); _visitables.get("quobyte").add(this.quobyte);} return (A) this;
  }
  public java.lang.Boolean hasQuobyte() {
    return this.quobyte != null;
  }
  public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyte() {
    return new PersistentVolumeSpecFluentImpl.QuobyteNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyteLike(io.fabric8.kubernetes.api.model.QuobyteVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.QuobyteNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.QuobyteNested<A> editQuobyte() {
    return withNewQuobyteLike(getQuobyte());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyte() {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyteLike(io.fabric8.kubernetes.api.model.QuobyteVolumeSource item) {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRbd instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public RBDPersistentVolumeSource getRbd() {
    return this.rbd!=null ?this.rbd.build():null;
  }
  public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource buildRbd() {
    return this.rbd!=null ?this.rbd.build():null;
  }
  public A withRbd(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource rbd) {
    _visitables.get("rbd").remove(this.rbd);
    if (rbd!=null){ this.rbd= new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder(rbd); _visitables.get("rbd").add(this.rbd);} return (A) this;
  }
  public java.lang.Boolean hasRbd() {
    return this.rbd != null;
  }
  public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd() {
    return new PersistentVolumeSpecFluentImpl.RbdNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.RbdNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.RbdNested<A> editRbd() {
    return withNewRbdLike(getRbd());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd() {
    return withNewRbdLike(getRbd() != null ? getRbd(): new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource item) {
    return withNewRbdLike(getRbd() != null ? getRbd(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildScaleIO instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource getScaleIO() {
    return this.scaleIO!=null ?this.scaleIO.build():null;
  }
  public io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource buildScaleIO() {
    return this.scaleIO!=null ?this.scaleIO.build():null;
  }
  public A withScaleIO(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource scaleIO) {
    _visitables.get("scaleIO").remove(this.scaleIO);
    if (scaleIO!=null){ this.scaleIO= new ScaleIOPersistentVolumeSourceBuilder(scaleIO); _visitables.get("scaleIO").add(this.scaleIO);} return (A) this;
  }
  public java.lang.Boolean hasScaleIO() {
    return this.scaleIO != null;
  }
  public PersistentVolumeSpecFluent.ScaleIONested<A> withNewScaleIO() {
    return new PersistentVolumeSpecFluentImpl.ScaleIONestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ScaleIONested<A> withNewScaleIOLike(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.ScaleIONestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ScaleIONested<A> editScaleIO() {
    return withNewScaleIOLike(getScaleIO());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ScaleIONested<A> editOrNewScaleIO() {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): new io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ScaleIONested<A> editOrNewScaleIOLike(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource item) {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): item);
  }
  public java.lang.String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(java.lang.String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public java.lang.Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorageos instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource getStorageos() {
    return this.storageos!=null ?this.storageos.build():null;
  }
  public io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource buildStorageos() {
    return this.storageos!=null ?this.storageos.build():null;
  }
  public A withStorageos(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource storageos) {
    _visitables.get("storageos").remove(this.storageos);
    if (storageos!=null){ this.storageos= new StorageOSPersistentVolumeSourceBuilder(storageos); _visitables.get("storageos").add(this.storageos);} return (A) this;
  }
  public java.lang.Boolean hasStorageos() {
    return this.storageos != null;
  }
  public PersistentVolumeSpecFluent.StorageosNested<A> withNewStorageos() {
    return new PersistentVolumeSpecFluentImpl.StorageosNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.StorageosNested<A> withNewStorageosLike(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.StorageosNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.StorageosNested<A> editStorageos() {
    return withNewStorageosLike(getStorageos());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.StorageosNested<A> editOrNewStorageos() {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): new io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.StorageosNested<A> editOrNewStorageosLike(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource item) {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): item);
  }
  public java.lang.String getVolumeMode() {
    return this.volumeMode;
  }
  public A withVolumeMode(java.lang.String volumeMode) {
    this.volumeMode=volumeMode; return (A) this;
  }
  public java.lang.Boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVsphereVolume instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource getVsphereVolume() {
    return this.vsphereVolume!=null ?this.vsphereVolume.build():null;
  }
  public io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource buildVsphereVolume() {
    return this.vsphereVolume!=null ?this.vsphereVolume.build():null;
  }
  public A withVsphereVolume(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource vsphereVolume) {
    _visitables.get("vsphereVolume").remove(this.vsphereVolume);
    if (vsphereVolume!=null){ this.vsphereVolume= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.get("vsphereVolume").add(this.vsphereVolume);} return (A) this;
  }
  public java.lang.Boolean hasVsphereVolume() {
    return this.vsphereVolume != null;
  }
  public A withNewVsphereVolume(java.lang.String fsType,java.lang.String storagePolicyID,java.lang.String storagePolicyName,java.lang.String volumePath) {
    return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume() {
    return new PersistentVolumeSpecFluentImpl.VsphereVolumeNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource item) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl.VsphereVolumeNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource item) {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
    if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
    if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
    if (azureDisk != null ? !azureDisk.equals(that.azureDisk) :that.azureDisk != null) return false;
    if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
    if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
    if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
    if (csi != null ? !csi.equals(that.csi) :that.csi != null) return false;
    if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
    if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
    if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
    if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
    if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
    if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
    if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
    if (local != null ? !local.equals(that.local) :that.local != null) return false;
    if (mountOptions != null ? !mountOptions.equals(that.mountOptions) :that.mountOptions != null) return false;
    if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
    if (nodeAffinity != null ? !nodeAffinity.equals(that.nodeAffinity) :that.nodeAffinity != null) return false;
    if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
    if (photonPersistentDisk != null ? !photonPersistentDisk.equals(that.photonPersistentDisk) :that.photonPersistentDisk != null) return false;
    if (portworxVolume != null ? !portworxVolume.equals(that.portworxVolume) :that.portworxVolume != null) return false;
    if (quobyte != null ? !quobyte.equals(that.quobyte) :that.quobyte != null) return false;
    if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
    if (scaleIO != null ? !scaleIO.equals(that.scaleIO) :that.scaleIO != null) return false;
    if (storageClassName != null ? !storageClassName.equals(that.storageClassName) :that.storageClassName != null) return false;
    if (storageos != null ? !storageos.equals(that.storageos) :that.storageos != null) return false;
    if (volumeMode != null ? !volumeMode.equals(that.volumeMode) :that.volumeMode != null) return false;
    if (vsphereVolume != null ? !vsphereVolume.equals(that.vsphereVolume) :that.vsphereVolume != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  awsElasticBlockStore,  azureDisk,  azureFile,  capacity,  cephfs,  cinder,  claimRef,  csi,  fc,  flexVolume,  flocker,  gcePersistentDisk,  glusterfs,  hostPath,  iscsi,  local,  mountOptions,  nfs,  nodeAffinity,  persistentVolumeReclaimPolicy,  photonPersistentDisk,  portworxVolume,  quobyte,  rbd,  scaleIO,  storageClassName,  storageos,  volumeMode,  vsphereVolume,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (awsElasticBlockStore != null) { sb.append("awsElasticBlockStore:"); sb.append(awsElasticBlockStore + ","); }
    if (azureDisk != null) { sb.append("azureDisk:"); sb.append(azureDisk + ","); }
    if (azureFile != null) { sb.append("azureFile:"); sb.append(azureFile + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (cephfs != null) { sb.append("cephfs:"); sb.append(cephfs + ","); }
    if (cinder != null) { sb.append("cinder:"); sb.append(cinder + ","); }
    if (claimRef != null) { sb.append("claimRef:"); sb.append(claimRef + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi + ","); }
    if (fc != null) { sb.append("fc:"); sb.append(fc + ","); }
    if (flexVolume != null) { sb.append("flexVolume:"); sb.append(flexVolume + ","); }
    if (flocker != null) { sb.append("flocker:"); sb.append(flocker + ","); }
    if (gcePersistentDisk != null) { sb.append("gcePersistentDisk:"); sb.append(gcePersistentDisk + ","); }
    if (glusterfs != null) { sb.append("glusterfs:"); sb.append(glusterfs + ","); }
    if (hostPath != null) { sb.append("hostPath:"); sb.append(hostPath + ","); }
    if (iscsi != null) { sb.append("iscsi:"); sb.append(iscsi + ","); }
    if (local != null) { sb.append("local:"); sb.append(local + ","); }
    if (mountOptions != null && !mountOptions.isEmpty()) { sb.append("mountOptions:"); sb.append(mountOptions + ","); }
    if (nfs != null) { sb.append("nfs:"); sb.append(nfs + ","); }
    if (nodeAffinity != null) { sb.append("nodeAffinity:"); sb.append(nodeAffinity + ","); }
    if (persistentVolumeReclaimPolicy != null) { sb.append("persistentVolumeReclaimPolicy:"); sb.append(persistentVolumeReclaimPolicy + ","); }
    if (photonPersistentDisk != null) { sb.append("photonPersistentDisk:"); sb.append(photonPersistentDisk + ","); }
    if (portworxVolume != null) { sb.append("portworxVolume:"); sb.append(portworxVolume + ","); }
    if (quobyte != null) { sb.append("quobyte:"); sb.append(quobyte + ","); }
    if (rbd != null) { sb.append("rbd:"); sb.append(rbd + ","); }
    if (scaleIO != null) { sb.append("scaleIO:"); sb.append(scaleIO + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (storageos != null) { sb.append("storageos:"); sb.append(storageos + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (vsphereVolume != null) { sb.append("vsphereVolume:"); sb.append(vsphereVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>,Nested<N>{
    AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AwsElasticBlockStoreNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }
    public N endAwsElasticBlockStore() {
      return and();
    }
    
  }
  class AzureDiskNestedImpl<N> extends AzureDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureDiskNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AzureDiskNestedImpl(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAzureDisk(builder.build());
    }
    public N endAzureDisk() {
      return and();
    }
    
  }
  class AzureFileNestedImpl<N> extends AzureFilePersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.AzureFileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AzureFileNestedImpl(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFileNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.AzureFilePersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAzureFile(builder.build());
    }
    public N endAzureFile() {
      return and();
    }
    
  }
  class CephfsNestedImpl<N> extends CephFSPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CephfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CephfsNestedImpl(io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
    }
    public N endCephfs() {
      return and();
    }
    
  }
  class CinderNestedImpl<N> extends CinderPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CinderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CinderNestedImpl(io.fabric8.kubernetes.api.model.CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CinderPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder() {
      return and();
    }
    
  }
  class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ClaimRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClaimRefNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ClaimRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
    }
    public N endClaimRef() {
      return and();
    }
    
  }
  class CsiNestedImpl<N> extends CSIPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CsiNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.CsiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CsiNestedImpl(io.fabric8.kubernetes.api.model.CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CsiNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.CSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCsi(builder.build());
    }
    public N endCsi() {
      return and();
    }
    
  }
  class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FcNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FcNestedImpl(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FcNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FCVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
    }
    public N endFc() {
      return and();
    }
    
  }
  class FlexVolumeNestedImpl<N> extends FlexPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlexVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FlexVolumeNestedImpl(io.fabric8.kubernetes.api.model.FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FlexPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume() {
      return and();
    }
    
  }
  class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.FlockerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FlockerNestedImpl(io.fabric8.kubernetes.api.model.FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker() {
      return and();
    }
    
  }
  class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GcePersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GcePersistentDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
    }
    public N endGcePersistentDisk() {
      return and();
    }
    
  }
  class GlusterfsNestedImpl<N> extends GlusterfsPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.GlusterfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GlusterfsNestedImpl(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs() {
      return and();
    }
    
  }
  class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.HostPathNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostPathNestedImpl(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath() {
      return and();
    }
    
  }
  class IscsiNestedImpl<N> extends ISCSIPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.IscsiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IscsiNestedImpl(io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    IscsiNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ISCSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi() {
      return and();
    }
    
  }
  class LocalNestedImpl<N> extends LocalVolumeSourceFluentImpl<PersistentVolumeSpecFluent.LocalNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.LocalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    LocalNestedImpl(io.fabric8.kubernetes.api.model.LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withLocal(builder.build());
    }
    public N endLocal() {
      return and();
    }
    
  }
  class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NfsNestedImpl(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NfsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
    }
    public N endNfs() {
      return and();
    }
    
  }
  class NodeAffinityNestedImpl<N> extends VolumeNodeAffinityFluentImpl<PersistentVolumeSpecFluent.NodeAffinityNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.NodeAffinityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeAffinityNestedImpl(io.fabric8.kubernetes.api.model.VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    NodeAffinityNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.VolumeNodeAffinityBuilder(this);
    }
    io.fabric8.kubernetes.api.model.VolumeNodeAffinityBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withNodeAffinity(builder.build());
    }
    public N endNodeAffinity() {
      return and();
    }
    
  }
  class PhotonPersistentDiskNestedImpl<N> extends PhotonPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PhotonPersistentDiskNestedImpl(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withPhotonPersistentDisk(builder.build());
    }
    public N endPhotonPersistentDisk() {
      return and();
    }
    
  }
  class PortworxVolumeNestedImpl<N> extends PortworxVolumeSourceFluentImpl<PersistentVolumeSpecFluent.PortworxVolumeNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.PortworxVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortworxVolumeNestedImpl(io.fabric8.kubernetes.api.model.PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withPortworxVolume(builder.build());
    }
    public N endPortworxVolume() {
      return and();
    }
    
  }
  class QuobyteNestedImpl<N> extends QuobyteVolumeSourceFluentImpl<PersistentVolumeSpecFluent.QuobyteNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.QuobyteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    QuobyteNestedImpl(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withQuobyte(builder.build());
    }
    public N endQuobyte() {
      return and();
    }
    
  }
  class RbdNestedImpl<N> extends RBDPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.RbdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RbdNestedImpl(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RbdNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd() {
      return and();
    }
    
  }
  class ScaleIONestedImpl<N> extends ScaleIOPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.ScaleIONested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.ScaleIONested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ScaleIONestedImpl(io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIONestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ScaleIOPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withScaleIO(builder.build());
    }
    public N endScaleIO() {
      return and();
    }
    
  }
  class StorageosNestedImpl<N> extends StorageOSPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluent.StorageosNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.StorageosNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StorageosNestedImpl(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageosNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withStorageos(builder.build());
    }
    public N endStorageos() {
      return and();
    }
    
  }
  class VsphereVolumeNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.VsphereVolumeNested<N>> implements io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent.VsphereVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVolumeNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withVsphereVolume(builder.build());
    }
    public N endVsphereVolume() {
      return and();
    }
    
  }
  
}